/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.base;

import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.dzenm.helper.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class FragmentHelper {
    private static final String TAG = FragmentHelper.class.getSimpleName() + "|";
    private AppCompatActivity mActivity;
    private Fragment mFragment;
    private List<Fragment> mFragments;
    private int mLayoutId;

    public FragmentHelper(AppCompatActivity activity, int layoutId, Fragment[] fragments) {
        this.mActivity = activity;
        this.mLayoutId = layoutId;
        this.mFragments = new ArrayList<Fragment>();
        for (int i = 0; i < fragments.length; ++i) {
            this.mFragments.add(fragments[i]);
        }
    }

    public FragmentHelper(Fragment fragment, int layoutID, Fragment[] fragments) {
        this.mFragment = fragment;
        this.mLayoutId = layoutID;
        this.mFragments = new ArrayList<Fragment>();
        for (int i = 0; i < fragments.length; ++i) {
            this.mFragments.add(fragments[i]);
        }
    }

    public FragmentHelper hideAll() {
        FragmentTransaction transaction = this.mActivity.getSupportFragmentManager().beginTransaction();
        for (int i = 0; i < this.mFragments.size(); ++i) {
            if (!this.mFragments.get(i).isVisible()) continue;
            transaction.hide(this.mFragments.get(i));
        }
        transaction.commitAllowingStateLoss();
        return this;
    }

    public FragmentHelper hideChildAll() {
        FragmentTransaction transaction = this.mFragment.getChildFragmentManager().beginTransaction();
        for (int i = 0; i < this.mFragments.size(); ++i) {
            if (!this.mFragments.get(i).isVisible()) continue;
            transaction.hide(this.mFragments.get(i));
        }
        transaction.commitAllowingStateLoss();
        return this;
    }

    public FragmentHelper show(Fragment fragment) {
        this.hideAll();
        FragmentTransaction transaction = this.mActivity.getSupportFragmentManager().beginTransaction();
        if (fragment.isAdded()) {
            transaction.show(fragment);
            Logger.d(TAG + this.mActivity.getClass().getSimpleName() + " show fragment: " + fragment.getClass().getSimpleName());
        } else {
            transaction.add(this.mLayoutId, fragment);
            this.mFragments.add(fragment);
            Logger.d(TAG + this.mActivity.getClass().getSimpleName() + " add and show fragment: " + fragment.getClass().getSimpleName());
        }
        transaction.commitAllowingStateLoss();
        return this;
    }

    public FragmentHelper showChild(Fragment fragment) {
        this.hideChildAll();
        FragmentTransaction transaction = this.mFragment.getChildFragmentManager().beginTransaction();
        if (fragment.isAdded()) {
            transaction.show(fragment);
            Logger.d(TAG + this.mFragment.getClass().getSimpleName() + " show fragment: " + fragment.getClass().getSimpleName());
        } else {
            transaction.add(this.mLayoutId, fragment);
            this.mFragments.add(fragment);
            Logger.d(TAG + this.mFragment.getClass().getSimpleName() + " add and show fragment: " + fragment.getClass().getSimpleName());
        }
        transaction.commitAllowingStateLoss();
        return this;
    }
}

