/*
 * Decompiled with CFR 0.152.
 */
package com.dzenm.helper.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.dzenm.helper.base.AbsBaseActivity;
import com.dzenm.helper.dialog.EditDialog;
import com.dzenm.helper.dialog.InfoDialog;
import com.dzenm.helper.log.Logger;
import com.dzenm.helper.os.OsHelper;
import com.dzenm.helper.os.ScreenHelper;
import com.dzenm.helper.share.ShareHelper;
import com.dzenm.helper.toast.Toa;

public abstract class AbsWebActivity
extends AbsBaseActivity {
    protected WebView mWebView;
    protected String mCurrentTitle;
    protected String mCurrentUrl;

    protected void setEnabledWebView(ViewGroup viewGroup, ProgressBar progressBar, String url) {
        this.setWebView(viewGroup, url);
        this.setWebClient(this.mWebView, progressBar);
        this.setWebSettings(this.mWebView);
        this.findNetworkAvailable();
    }

    protected void setWebView(ViewGroup viewGroup, String url) {
        this.getSupportActionBar().setTitle((CharSequence)"\u6b63\u5728\u52a0\u8f7d\u4e2d...");
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mWebView = new WebView(this.getApplicationContext());
        this.mWebView.setLayoutParams(params);
        viewGroup.addView((View)this.mWebView);
        Logger.d(this.TAG + "load url: " + url);
        this.mWebView.loadUrl(url);
    }

    protected void setWebClient(final WebView webView, final ProgressBar progressBar) {
        webView.setWebViewClient(new WebViewClient(){

            @SuppressLint(value={"SetJavaScriptEnabled"})
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url = request.getUrl().getPath();
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    if ("file".equals(request.getUrl().getScheme())) {
                        view.getSettings().setJavaScriptEnabled(false);
                    } else {
                        view.getSettings().setJavaScriptEnabled(true);
                    }
                    assert (url != null);
                    if (url.startsWith("weixin://")) {
                        url = url.replace("weixin://", "http://");
                        webView.loadUrl(url);
                    }
                    view.loadUrl(url);
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }

            public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
                return super.shouldOverrideKeyEvent(view, event);
            }

            @Nullable
            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                return super.shouldInterceptRequest(view, request);
            }
        });
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                if (progressBar != null) {
                    if (newProgress >= 0 && newProgress < 100) {
                        progressBar.setVisibility(0);
                        progressBar.setProgress(newProgress);
                    } else {
                        progressBar.setVisibility(8);
                    }
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    AbsWebActivity.this.getSupportActionBar().setTitle((CharSequence)title);
                    AbsWebActivity.this.mCurrentTitle = title;
                    AbsWebActivity.this.mCurrentUrl = view.getUrl();
                }
                if (OsHelper.isMarshmallow() && (title.contains("404") || title.contains("500") || title.contains("Error"))) {
                    view.loadUrl("about:blank");
                }
            }

            public void onReceivedIcon(WebView view, Bitmap icon) {
                super.onReceivedIcon(view, icon);
            }

            public void onGeolocationPermissionsHidePrompt() {
                super.onGeolocationPermissionsHidePrompt();
            }

            public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                callback.invoke(origin, true, false);
                super.onGeolocationPermissionsShowPrompt(origin, callback);
            }

            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                transport.setWebView(view);
                resultMsg.sendToTarget();
                return true;
            }

            public void onCloseWindow(WebView window) {
                super.onCloseWindow(window);
            }

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Toast.makeText((Context)AbsWebActivity.this, (CharSequence)message, (int)0).show();
                return true;
            }

            public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
                InfoDialog.newInstance(AbsWebActivity.this).setTitle("\u662f\u5426\u786e\u5b9a\uff1f").setMessage(message).setOnDialogClickListener(new InfoDialog.OnInfoClickListener(){

                    @Override
                    public boolean onClick(InfoDialog dialog, boolean confirm) {
                        if (confirm) {
                            result.confirm();
                        } else {
                            result.cancel();
                        }
                        return true;
                    }
                }).show();
                return true;
            }

            public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, final JsPromptResult result) {
                EditDialog.newInstance(AbsWebActivity.this).setTitle(message).setMessage(defaultValue).setOnDialogClickListener(new EditDialog.OnEditClickListener(){

                    @Override
                    public boolean onClick(EditDialog dialog, boolean confirm) {
                        if (confirm) {
                            result.confirm(dialog.getMessage());
                        } else {
                            result.cancel();
                        }
                        return true;
                    }
                }).show();
                return true;
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            }

            public void onHideCustomView() {
            }
        });
        webView.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                AbsWebActivity.this.startActivity(intent);
            }
        });
        webView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                WebView.HitTestResult result = ((WebView)v).getHitTestResult();
                if (result != null) {
                    switch (result.getType()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 5: {
                            String imgUrl = result.getExtra();
                            break;
                        }
                    }
                }
                return false;
            }
        });
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void setWebSettings(WebView webView) {
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        String userAgent = webSettings.getUserAgentString();
        Logger.d(this.TAG + "userAgent: " + userAgent);
        if (OsHelper.isLollipop()) {
            webSettings.setMixedContentMode(0);
        }
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setCacheMode(1);
        webSettings.setStandardFontFamily("");
        webSettings.setDefaultFontSize(20);
        webSettings.setMinimumFontSize(12);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setDisplayZoomControls(false);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setAppCacheEnabled(true);
        String appCachePath = this.getApplicationContext().getCacheDir().getAbsolutePath();
        webSettings.setAppCachePath(appCachePath);
        webSettings.setAllowFileAccess(false);
        webSettings.setAllowFileAccessFromFileURLs(false);
        webSettings.setAllowUniversalAccessFromFileURLs(false);
        webSettings.setSupportMultipleWindows(false);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setGeolocationEnabled(true);
    }

    @Override
    protected void onConnectNetwork() {
        this.mWebView.reload();
    }

    @Override
    protected void onUnConnectNetWork() {
        super.onUnConnectNetWork();
        this.mWebView.stopLoading();
    }

    protected void reload() {
        this.mWebView.reload();
    }

    protected void share(String prompt) {
        ShareHelper.newInstance((Activity)this).setText(this.mWebView.getTitle() + "  \u5206\u4eab\u6765\u81ea\u3010" + prompt + "\u3011 " + this.mWebView.getUrl()).share();
    }

    protected void copy() {
        ScreenHelper.copy((Context)this, this.mWebView.getUrl());
        Toa.show("\u590d\u5236\u6210\u529f");
    }

    protected void openInBrowser() {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)this.mWebView.getUrl()));
        this.startActivity(intent);
    }

    protected void clearCache() {
        this.mWebView.clearCache(true);
        this.mWebView.clearHistory();
        this.mWebView.clearFormData();
        Toa.show("\u6e05\u9664\u7f13\u5b58\u6210\u529f");
    }

    protected void goForward() {
        if (this.mWebView.canGoForward()) {
            this.mWebView.goForward();
        }
    }

    protected void goBack() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebView.canGoBack()) {
            this.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onResume() {
        super.onResume();
        this.mWebView.onResume();
        this.mWebView.resumeTimers();
        this.mWebView.getSettings().setJavaScriptEnabled(true);
    }

    protected void onPause() {
        super.onPause();
        this.mWebView.onPause();
        this.mWebView.pauseTimers();
    }

    protected void onStop() {
        super.onStop();
        this.mWebView.getSettings().setJavaScriptEnabled(false);
    }

    public void onBackPressed() {
        if (this.mWebView.copyBackForwardList().getCurrentIndex() > 0) {
            this.goBack();
            if (!this.mWebView.canGoBack()) {
                super.onBackPressed();
            }
        } else {
            this.finish();
        }
    }

    @Override
    protected void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.clearHistory();
            this.mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            ViewGroup viewGroup = (ViewGroup)this.mWebView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView((View)this.mWebView);
            }
            this.mWebView.stopLoading();
            this.mWebView.setWebViewClient(null);
            this.mWebView.setWebChromeClient(null);
            this.mWebView.destroy();
            this.mWebView = null;
        }
        super.onDestroy();
    }
}

