/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.shared;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ResolvingClassWriter
extends ClassWriter {
    private final ClassLoader loader;

    public ResolvingClassWriter(ClassReader classReader, int flags, ClassLoader loader) {
        super(classReader, flags);
        this.loader = loader;
    }

    public ResolvingClassWriter(int flags, ClassLoader loader) {
        super(flags);
        this.loader = loader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        try {
            c = Class.forName(type1.replace('/', '.'), false, this.loader);
            d = Class.forName(type2.replace('/', '.'), false, this.loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (!c.isInterface() && !d.isInterface()) {
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
        return "java/lang/Object";
    }
}

