/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassLoaderClassResolver;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.filter.MethodLevelFilter;
import com.dynatrace.android.instrumentation.filter.PackageExclusionFilter;
import com.dynatrace.android.instrumentation.shared.ResolvingClassWriter;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instrumentor {
    private static final Logger logger = LoggerFactory.getLogger((String)"Instrumentor");
    private final ClassResolver classResolver;
    private final List<SubTransformer> transformers;
    private ExclusionManager exclusionManager = null;

    private Instrumentor(ClassResolver classResolver, List<SubTransformer> transformers) {
        this.classResolver = classResolver;
        this.transformers = transformers;
    }

    private boolean shouldBeInstrumented(ClassInfo classInfo) {
        boolean instrument = true;
        for (SubTransformer transformer : this.transformers) {
            instrument &= transformer.shouldBeInstrumented(classInfo);
        }
        if (!instrument) {
            logger.debug("Ignore class {}", (Object)classInfo.getName());
            return false;
        }
        return true;
    }

    public byte[] instrument(String className, byte[] bytes) throws ClassNotFoundException {
        byte[] modBytes;
        if (this.exclusionManager.filterClass(className)) {
            return bytes;
        }
        ClassInfo classInfo = this.classResolver.resolveClass(className);
        if (!this.shouldBeInstrumented(classInfo)) {
            return bytes;
        }
        ClassNode cn = new ClassNode();
        try {
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)cn, 0);
        }
        catch (Throwable t) {
            logger.info("skip non readable class {}, {}", (Object)className, (Object)t.toString());
            return bytes;
        }
        if (!this.transform0(cn, classInfo)) {
            logger.debug("No modifications for {}", (Object)classInfo.getName());
            return bytes;
        }
        try {
            ResolvingClassWriter writer = new ResolvingClassWriter(1 | (cn.version >= 51 ? 2 : 0), ((ClassLoaderClassResolver)this.classResolver).getClassLoader());
            cn.accept((ClassVisitor)writer);
            modBytes = writer.toByteArray();
        }
        catch (Throwable t) {
            logger.info("skip non writeable class {}, {}", (Object)className, (Object)t.toString());
            return bytes;
        }
        return modBytes;
    }

    public void instrument(ClassNode classNode) {
        ClassInfo classInfo = this.classResolver.resolveClass(Utils.slashToDot(classNode.name));
        if (!this.shouldBeInstrumented(classInfo)) {
            return;
        }
        if (!this.transform0(classNode, classInfo)) {
            logger.debug("No modifications for {}", (Object)classNode.name);
        }
    }

    private boolean transform0(ClassNode classNode, ClassInfo classInfo) {
        boolean transformed = false;
        for (SubTransformer transformer : this.transformers) {
            transformed |= transformer.transformClass(classInfo, classNode, this.exclusionManager);
        }
        ArrayList methods = new ArrayList(classNode.methods);
        for (MethodNode method : methods) {
            if (method.instructions == null || method.instructions.size() == 0 || this.exclusionManager.filterMethod(classNode.name.replaceAll("/", "."), method.name, method.desc)) continue;
            if (method.localVariables == null) {
                method.localVariables = new ArrayList();
            }
            for (SubTransformer transformer : this.transformers) {
                transformed |= transformer.transformMethod(classInfo, classNode, method, this.exclusionManager);
            }
        }
        return transformed;
    }

    public static class Builder {
        private static final List<String> EXCLUDE_FIREBASE_PERF = Arrays.asList("com.google.firebase.perf", "com.google.android.gms.internal.firebase-perf");
        private ClassResolver classResolver = null;
        private List<TransformerFactory> factories = new ArrayList<TransformerFactory>();
        private ExclusionManager exclusionManager = new ExclusionManager(new ArrayList<ClassLevelFilter>(), new ArrayList<MethodLevelFilter>());

        public Builder setClassResolver(ClassResolver classResolver) {
            this.classResolver = classResolver;
            return this;
        }

        public Builder setExclusionManager(ExclusionManager exclusionManager) {
            this.exclusionManager = exclusionManager;
            return this;
        }

        public Builder setTransformerFactories(List<TransformerFactory> factories) {
            this.factories = factories;
            return this;
        }

        public Builder addTransformerFactory(TransformerFactory factory) {
            this.factories.add(factory);
            return this;
        }

        public Builder addTransformerFactories(TransformerFactory ... factories) {
            for (TransformerFactory factory : factories) {
                this.addTransformerFactory(factory);
            }
            return this;
        }

        public Instrumentor build() throws Exception {
            if (this.classResolver == null) {
                throw new IllegalArgumentException("Missing component classResolver");
            }
            this.exclusionManager.addClassFileFilter(Arrays.asList(new PackageExclusionFilter("com.dynatrace.android"), new PackageExclusionFilter("com.dynatrace.agent"), className -> className.endsWith("package-info"), className -> className.endsWith("module-info")));
            this.exclusionManager.addClassFileFilter(EXCLUDE_FIREBASE_PERF.stream().map(PackageExclusionFilter::new).collect(Collectors.toList()));
            ArrayList<SubTransformer> transformers = new ArrayList<SubTransformer>();
            for (TransformerFactory factory : this.factories) {
                SubTransformer transformer = factory.generateTransformer(this.classResolver);
                if (transformer == null) continue;
                transformers.add(transformer);
                this.exclusionManager.addMandatoryClasses(factory.mandatoryClasses());
                this.exclusionManager.addClassFileFilter(factory.excludeClassFiles());
            }
            Instrumentor instrumentor = new Instrumentor(this.classResolver, transformers);
            instrumentor.exclusionManager = this.exclusionManager;
            return instrumentor;
        }
    }
}

