/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.manifest;

import com.dynatrace.tools.android.InstrumentationException;
import com.dynatrace.tools.android.manifest.ManifestInstrumentor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManifestTransformationTask
extends DefaultTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ManifestTransformationTask");

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public abstract RegularFileProperty getInputManifest();

    @OutputFile
    public abstract RegularFileProperty getInstrumentedManifest();

    @TaskAction
    public final void taskAction() {
        String manifestContent;
        Path inputManifestPath = ((File)this.getInputManifest().getAsFile().get()).toPath();
        Path instrumentedManifestPath = ((File)this.getInstrumentedManifest().getAsFile().get()).toPath();
        LOGGER.debug("Transforming the manifest at: " + inputManifestPath);
        try {
            byte[] bytes = Files.readAllBytes(inputManifestPath);
            manifestContent = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InstrumentationException("Failed to read merged manifest file");
        }
        String instrumentedManifest = new ManifestInstrumentor().instrumentManifest(manifestContent);
        try {
            Files.write(instrumentedManifestPath, instrumentedManifest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            LOGGER.debug("Transformed manifest was written to: " + instrumentedManifestPath);
        }
        catch (IOException e) {
            throw new InstrumentationException("Failed to write instrumented manifest file");
        }
    }
}

