/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.dynatrace.tools.android.AgpVersion;
import com.dynatrace.tools.android.AgpVersionUtil;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgpVersionConverter {
    private static final Logger logger = LoggerFactory.getLogger((String)"AgpVersionConverter");

    public AgpVersion determineAndroidPluginVersion(Project project) {
        AgpVersion agpVersion;
        AndroidComponentsExtension androidExtension = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        AndroidPluginVersion androidPluginVersion = androidExtension.getPluginVersion();
        if (androidPluginVersion.getPreviewType() != null) {
            logger.info("[Dynatrace] Preview version of the Android Gradle plugin detected. For production builds a stable Android Gradle plugin version is recommended.");
        }
        if (AgpVersionUtil.isVersionTooHigh(agpVersion = new AgpVersion(androidPluginVersion.getMajor(), androidPluginVersion.getMinor()))) {
            throw new RuntimeException(androidPluginVersion + " is not supported. Make sure to use the latest version of the Dynatrace Android Gradle Plugin");
        }
        return agpVersion;
    }
}

