/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionReplayFragmentTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"SessionReplayFragmentTransformerFactory");
    private static final String ANDROID_FRAGMENT = "androidx.fragment.app.Fragment";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateAndroidxFragmentSensors());
        return new DefaultSubTransformer("SessionReplayFragmentTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateAndroidxFragmentSensors() {
        String fragmentClassName = Utils.dotToSlash(ANDROID_FRAGMENT);
        String instrumentorClassName = Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorApi");
        ParameterInstructionProvider provider = (instructions, startParameterIndex) -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, startParameterIndex));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, startParameterIndex + 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, startParameterIndex + 2));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createPublicMethodInstruction(fragmentClassName, "getContext", "()Landroid/content/Context;")));
        };
        MethodInfo onViewCreated = new MethodInfo("onViewCreated", "(Landroid/view/View;Landroid/os/Bundle;)V", 1, null, new ArrayList<String>());
        MethodInfo onCreateAnimation = new MethodInfo("onCreateAnimation", "(IZI)Landroid/view/animation/Animation;", 1, null, new ArrayList<String>());
        MethodInfo onCreateAnimator = new MethodInfo("onCreateAnimator", "(IZI)Landroid/animation/Animator;", 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ANDROID_FRAGMENT.equals(otherClassInfo.getName()), new MethodSensorImpl(onViewCreated, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(instrumentorClassName, "fragmentViewCreated", "(Ljava/lang/Object;Landroid/view/View;Landroid/os/Bundle;)V"), ParameterInstructionProvider.withThisAndAllParameters("(Landroid/view/View;Landroid/os/Bundle;)V"))), new MethodSensorImpl(onCreateAnimation, new ReplaceInsnListTransformation(MethodInstruction.createStaticMethodInstruction(instrumentorClassName, "onCreateFragmentAnimation", "(Ljava/lang/Object;IZILandroid/content/Context;)Landroid/view/animation/Animation;"), provider)), new MethodSensorImpl(onCreateAnimator, new ReplaceInsnListTransformation(MethodInstruction.createStaticMethodInstruction(instrumentorClassName, "onCreateFragmentAnimator", "(Ljava/lang/Object;IZILandroid/content/Context;)Landroid/animation/Animator;"), provider)));
    }

    private static class ReplaceInsnListTransformation
    implements MethodTransformation {
        private final MethodInstruction instrumentedMethod;
        private final ParameterInstructionProvider paramInstructionProvider;

        public ReplaceInsnListTransformation(MethodInstruction instrumentedMethod, ParameterInstructionProvider paramInstructionProvider) {
            this.instrumentedMethod = instrumentedMethod;
            this.paramInstructionProvider = paramInstructionProvider;
        }

        @Override
        public void transformMethod(MethodNode methodNode, int startParameterIndex) {
            InsnList instructions = methodNode.instructions;
            instructions.clear();
            this.paramInstructionProvider.addParameterInstructions(instructions, startParameterIndex);
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(this.instrumentedMethod));
            instructions.add((AbstractInsnNode)new InsnNode(176));
        }
    }
}

