/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertAfterInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;

public class HttpUrlConnectionTransformerFactory
implements TransformerFactory {
    private static final String HTTP_URL_CONNECTION = "java.net.HttpURLConnection";
    private static final String URL_CONNECTION = "java.net.URLConnection";
    private static final String URL = "java.net.URL";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateHttpUrlConnectionSensors(classResolver));
        instructionSensors.add(this.generateUrlConnectionSensors());
        instructionSensors.add(this.generateUrlSensors());
        return new DefaultSubTransformer("HttpUrlConnectionTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classResolver);
    }

    private SensorGroup<InstructionSensor> generateHttpUrlConnectionSensors(ClassResolver classResolver) {
        String dynatraceClassName = Utils.dotToSlash("com.dynatrace.android.callback.Callback");
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(HTTP_URL_CONNECTION), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(HTTP_URL_CONNECTION), "getResponseCode", "()I"), MethodInstruction.createStaticMethodInstruction(dynatraceClassName, "getResponseCode", "(Ljava/net/HttpURLConnection;)I")), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL_CONNECTION), "getInputStream", "()Ljava/io/InputStream;"), MethodInstruction.createStaticMethodInstruction(dynatraceClassName, "getInputStream", "(Ljava/net/HttpURLConnection;)Ljava/io/InputStream;")), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL_CONNECTION), "getOutputStream", "()Ljava/io/OutputStream;"), MethodInstruction.createStaticMethodInstruction(dynatraceClassName, "getOutputStream", "(Ljava/net/HttpURLConnection;)Ljava/io/OutputStream;")), new InsertAfterInstructionSensor("<init>", instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(dynatraceClassName, "newInstance", "(Ljava/net/HttpURLConnection;)V")));
        }));
    }

    private SensorGroup<InstructionSensor> generateUrlConnectionSensors() {
        return new SensorGroupImpl<InstructionSensor>(otherClassInfo -> URL_CONNECTION.equals(otherClassInfo.getName()), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL_CONNECTION), "getInputStream", "()Ljava/io/InputStream;"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "getInputStream", "(Ljava/net/URLConnection;)Ljava/io/InputStream;")), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL_CONNECTION), "getOutputStream", "()Ljava/io/OutputStream;"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "getOutputStream", "(Ljava/net/URLConnection;)Ljava/io/OutputStream;")));
    }

    private SensorGroup<InstructionSensor> generateUrlSensors() {
        return new SensorGroupImpl<InstructionSensor>(otherClassInfo -> URL.equals(otherClassInfo.getName()), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(URL), "openConnection", "()Ljava/net/URLConnection;"), instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "openConnection", "(Ljava/net/URLConnection;)V")));
        }));
    }
}

