/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.compose;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.compose.ComposeTransformation;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ComposeSubTransformer
implements SubTransformer {
    private final String name;
    private final List<ComposeTransformation> transformers;

    public ComposeSubTransformer(String name, List<ComposeTransformation> transformers) {
        this.name = name;
        this.transformers = transformers;
    }

    @Override
    public boolean transformClass(ClassInfo classInfo, ClassNode classNode, ExclusionManager exclusionManager) {
        ComposeTransformation transformer = this.getTransformer(classInfo);
        if (transformer != null) {
            return transformer.transformClass(classNode);
        }
        return false;
    }

    @Override
    public boolean transformMethod(ClassInfo classInfo, ClassNode classNode, MethodNode methodNode, ExclusionManager exclusionManager) {
        ComposeTransformation transformer = this.getTransformer(classInfo);
        if (transformer != null) {
            return transformer.transformMethod(methodNode);
        }
        return false;
    }

    @Override
    public boolean shouldBeInstrumented(ClassInfo classInfo) {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private ComposeTransformation getTransformer(ClassInfo info) {
        return this.transformers.stream().filter(value -> value.exactClassForInstrumentation(info.getName())).findFirst().orElse(null);
    }
}

