/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class SessionReplayComposeViewSensor
implements SensorGroup<MethodSensor> {
    private static final String ANDROID_COMPOSE_VIEW_SOURCE = "androidx.compose.ui.platform.AndroidComposeView";
    private static final String ON_RESUME_FUNCTION_NAME = "onResume";
    private static final String ON_RESUME_DESCRIPTION = "(Landroidx/lifecycle/LifecycleOwner;)V";
    private static final String ON_LAYOUT_CHANGE_FUNCTION_NAME = "onLayoutChange";
    private static final String ON_LAYOUT_CHANGE_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";
    private static final String ON_DETACH_FUNCTION_NAME = "onDetach";
    private static final String ON_DETACH_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return ANDROID_COMPOSE_VIEW_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateOnResumeSensor(), this.generateOnLayoutChangeSensor(), this.generateOnDetachSensor());
    }

    private MethodSensor generateOnResumeSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_RESUME_FUNCTION_NAME, ON_RESUME_DESCRIPTION, 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), ON_RESUME_FUNCTION_NAME, "(Ljava/lang/Object;)V"), ParameterInstructionProvider.withThis()));
    }

    private MethodSensor generateOnLayoutChangeSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_LAYOUT_CHANGE_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), ON_LAYOUT_CHANGE_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }

    private MethodSensor generateOnDetachSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_DETACH_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), ON_DETACH_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }
}

