/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation;

public class MethodInstruction {
    private final int opcode;
    private final String className;
    private final String methodName;
    private final String methodDescriptor;
    private final boolean classIsInterface;

    private MethodInstruction(int opcode, String className, String methodName, String methodDescriptor, boolean classIsInterface) {
        this.opcode = opcode;
        this.className = className;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.classIsInterface = classIsInterface;
    }

    public static MethodInstruction createPrivateMethodInstruction(String className, String methodName, String methodDescriptor) {
        return new MethodInstruction(183, className, methodName, methodDescriptor, false);
    }

    public static MethodInstruction createSuperMethodInstruction(String className, String methodName, String methodDescriptor) {
        return new MethodInstruction(183, className, methodName, methodDescriptor, false);
    }

    public static MethodInstruction createPublicMethodInstruction(String className, String methodName, String methodDescriptor) {
        return new MethodInstruction(182, className, methodName, methodDescriptor, false);
    }

    public static MethodInstruction createStaticMethodInstruction(String className, String methodName, String methodDescriptor) {
        return new MethodInstruction(184, className, methodName, methodDescriptor, false);
    }

    public static MethodInstruction createInterfaceMethodInstruction(String className, String methodName, String methodDescriptor) {
        return new MethodInstruction(185, className, methodName, methodDescriptor, true);
    }

    public static MethodInstruction createStaticInterfaceMethodInstruction(String className, String methodName, String methodDescriptor) {
        return new MethodInstruction(184, className, methodName, methodDescriptor, true);
    }

    public static MethodInstruction createConstructorInstruction(String className, String constructorDescriptor) {
        return new MethodInstruction(183, className, "<init>", constructorDescriptor, false);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public boolean isClassInterface() {
        return this.classIsInterface;
    }
}

