/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dependencies;

import com.dynatrace.tools.android.dependencies.AgentArtifactVerifier;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyVerifier {
    private static final Logger logger = LoggerFactory.getLogger((String)"DependencyVerifier");
    private final Project project;

    public DependencyVerifier(Project project) {
        this.project = project;
    }

    public void configureAgentArtifactVerification(String configurationName) {
        try {
            Configuration configuration = this.project.getConfigurations().getByName(configurationName);
            configuration.getIncoming().afterResolve(resolvableDependencies -> resolvableDependencies.getResolutionResult().getAllComponents().forEach(new AgentArtifactVerifier()));
        }
        catch (UnknownConfigurationException e) {
            logger.warn("Could not verify agent artifacts in configuration '" + configurationName + "'");
            logger.debug("Agent artifact verification canceled because of error: ", (Throwable)e);
        }
    }
}

