/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.classpath;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInput;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ClassPathGenerator
implements Supplier<URL[]> {
    private Collection<File> bootClasspath;
    private Collection<TransformInput> inputs;
    private Collection<TransformInput> referencedInputs;

    public ClassPathGenerator(Collection<File> bootClasspath, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs) {
        this.bootClasspath = bootClasspath;
        this.inputs = inputs;
        this.referencedInputs = referencedInputs;
    }

    private static Stream<File> convertToFileStream(Collection<TransformInput> input) {
        return input.stream().flatMap(transformInput -> Stream.of(transformInput.getDirectoryInputs(), transformInput.getJarInputs())).flatMap(Collection::stream).map(QualifiedContent::getFile);
    }

    private static URL convertUriToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("invalid uri: " + uri, e);
        }
    }

    @Override
    public URL[] get() {
        return (URL[])Stream.of(this.bootClasspath.stream(), ClassPathGenerator.convertToFileStream(this.inputs), ClassPathGenerator.convertToFileStream(this.referencedInputs)).flatMap(Function.identity()).map(File::toURI).map(ClassPathGenerator::convertUriToUrl).toArray(URL[]::new);
    }
}

