/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.util;

import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.UnknownLambdaTagException;
import com.dynatrace.android.instrumentation.util.LambdaConverterData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger((String)"Utils");

    public static LambdaConverterData extractLambdaIntoExtraMethod(String methodName, Handle methodHandle, Type typeMethodDesc, Type[] callArgumentTypes) throws UnknownLambdaTagException {
        int opcode;
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(Arrays.asList(callArgumentTypes));
        types.addAll(Arrays.asList(typeMethodDesc.getArgumentTypes()));
        StringBuilder sb = new StringBuilder("(");
        for (Type paramType : types) {
            sb.append(paramType.getDescriptor());
        }
        sb.append(")");
        sb.append(typeMethodDesc.getReturnType().getDescriptor());
        int access = 4106;
        MethodNode methodNode = new MethodNode(access, methodName, sb.toString(), null, null);
        InsnList instructions = methodNode.instructions;
        if (methodHandle.getTag() == 8) {
            instructions.add((AbstractInsnNode)new TypeInsnNode(187, methodHandle.getOwner()));
            instructions.add((AbstractInsnNode)new InsnNode(89));
        }
        int slotCount = 0;
        for (Type paramType : types) {
            instructions.add((AbstractInsnNode)new VarInsnNode(paramType.getOpcode(21), slotCount));
            slotCount += paramType.getSize();
        }
        switch (methodHandle.getTag()) {
            case 5: {
                opcode = 182;
                break;
            }
            case 6: {
                opcode = 184;
                break;
            }
            case 7: 
            case 8: {
                opcode = 183;
                break;
            }
            case 9: {
                opcode = 185;
                break;
            }
            default: {
                throw new UnknownLambdaTagException("Unsupported tag value " + methodHandle.getTag() + " in method handle");
            }
        }
        MethodInsnNode methodInsnNode = new MethodInsnNode(opcode, methodHandle.getOwner(), methodHandle.getName(), methodHandle.getDesc(), methodHandle.isInterface());
        instructions.add((AbstractInsnNode)methodInsnNode);
        instructions.add((AbstractInsnNode)new InsnNode(typeMethodDesc.getReturnType().getOpcode(172)));
        return new LambdaConverterData(methodNode, methodInsnNode);
    }

    public static MethodNode generateSyntheticMethod(String oldClassName, MethodInfo methodInfo, String newMethodName, boolean isSuperCall) {
        boolean isPrivate;
        boolean isStatic;
        Type methodDesc = Type.getType((String)methodInfo.getMethodDescriptor());
        List<String> exceptions = methodInfo.getExceptions();
        String[] exceptionNames = exceptions != null ? methodInfo.getExceptions().toArray(new String[methodInfo.getExceptions().size()]) : new String[]{};
        int modifiers = methodInfo.getAccessFlags() | 0x1000;
        MethodNode methodNode = new MethodNode(modifiers, newMethodName, methodInfo.getMethodDescriptor(), methodInfo.getSignature(), exceptionNames);
        InsnList instructions = methodNode.instructions;
        int slotCount = 0;
        boolean bl = isStatic = (methodInfo.getAccessFlags() & 8) != 0;
        if (!isStatic) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, slotCount));
            ++slotCount;
        }
        for (Type paramType : methodDesc.getArgumentTypes()) {
            instructions.add((AbstractInsnNode)new VarInsnNode(paramType.getOpcode(21), slotCount));
            slotCount += paramType.getSize();
        }
        boolean bl2 = isPrivate = isSuperCall || (methodInfo.getAccessFlags() & 2) != 0;
        instructions.add((AbstractInsnNode)new MethodInsnNode(isStatic ? 184 : (isPrivate ? 183 : 182), oldClassName, methodInfo.getMethodName(), methodInfo.getMethodDescriptor(), false));
        instructions.add((AbstractInsnNode)new InsnNode(methodDesc.getReturnType().getOpcode(172)));
        return methodNode;
    }

    public static MethodInsnNode generateMethodInstructionNode(MethodInstruction methodInstruction) {
        return new MethodInsnNode(methodInstruction.getOpcode(), methodInstruction.getClassName(), methodInstruction.getMethodName(), methodInstruction.getMethodDescriptor(), methodInstruction.isClassInterface());
    }

    public static void pushValueToStack(InsnList insn, int value) {
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)value));
    }

    public static void pushValueToStack(InsnList insn, boolean value) {
        insn.add((AbstractInsnNode)new InsnNode(value ? 4 : 3));
    }

    public static void pushValueToStack(InsnList insn, String value) {
        if (value == null) {
            Utils.pushNullToStack(insn);
            return;
        }
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)value));
    }

    public static void pushValueToStack(InsnList insn, String[] values) {
        if (values == null) {
            Utils.pushNullToStack(insn);
            return;
        }
        Utils.pushValueToStack(insn, values.length);
        Type t = Type.getType(values.getClass());
        insn.add((AbstractInsnNode)new TypeInsnNode(189, t.getElementType().getInternalName()));
        for (int i = 0; i < values.length; ++i) {
            insn.add((AbstractInsnNode)new InsnNode(89));
            Utils.pushValueToStack(insn, i);
            Utils.pushValueToStack(insn, values[i]);
            insn.add((AbstractInsnNode)new InsnNode(83));
        }
    }

    public static void pushNullToStack(InsnList insn) {
        insn.add((AbstractInsnNode)new InsnNode(1));
    }

    public static <E extends Enum<E>> void pushEnumToStack(InsnList insn, E enumValue) {
        if (enumValue == null) {
            Utils.pushNullToStack(insn);
            return;
        }
        Type type = Type.getType(enumValue.getClass());
        insn.add((AbstractInsnNode)new FieldInsnNode(178, type.getInternalName(), enumValue.name(), type.getDescriptor()));
    }

    public static <E extends Enum<E>> void replaceEnumGetterInstructions(InsnList insn, String enumClass, String enumValue) {
        insn.clear();
        insn.add((AbstractInsnNode)new FieldInsnNode(178, enumClass, enumValue, "L" + enumClass + ";"));
        insn.add((AbstractInsnNode)new InsnNode(176));
    }

    public static void replaceGetterInstructions(InsnList insn, int valueToReturn) {
        insn.clear();
        Utils.pushValueToStack(insn, valueToReturn);
        insn.add((AbstractInsnNode)new InsnNode(172));
    }

    public static void replaceGetterInstructions(InsnList insn, boolean valueToReturn) {
        insn.clear();
        Utils.pushValueToStack(insn, valueToReturn);
        insn.add((AbstractInsnNode)new InsnNode(172));
    }

    public static void replaceGetterInstructions(InsnList insn, String[] valuesToReturn) {
        insn.clear();
        Utils.pushValueToStack(insn, valuesToReturn);
        insn.add((AbstractInsnNode)new InsnNode(176));
    }

    public static String dotToSlash(String classNameInDotNotation) {
        return classNameInDotNotation.replaceAll("\\.", "/");
    }

    public static String slashToDot(String classNameInSlashNotation) {
        return classNameInSlashNotation.replaceAll("/", ".");
    }
}

