/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class FullSessionReplayTransformerFactory
implements TransformerFactory {
    private static final String CONFIGURATION_CLASS = "com.dynatrace.android.agent.conf.ConfigurationFactory";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateEnableFullSessionReplaySensor());
        return new DefaultSubTransformer("FullSessionReplayTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    @Override
    public List<String> mandatoryClasses() {
        return List.of(CONFIGURATION_CLASS);
    }

    private SensorGroup<MethodSensor> generateEnableFullSessionReplaySensor() {
        MethodInfo methodInfo = new MethodInfo("isFullSessionEnabled", "()Z", 9, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CONFIGURATION_CLASS.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new FullSessionReplayTransformation()));
    }

    private static class FullSessionReplayTransformation
    implements MethodTransformation {
        private FullSessionReplayTransformation() {
        }

        @Override
        public void transformMethod(MethodNode methodNode, int startParameterIndex) {
            InsnList instructions = methodNode.instructions;
            Utils.replaceGetterInstructions(instructions, true);
        }
    }
}

