/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class SessionReplayNavControllerSensor
implements SensorGroup<MethodSensor> {
    private static final String NAV_CONTROLLER_SOURCE = "androidx.navigation.NavController";
    private static final String NAVIGATE_FUNCTION_NAME = "navigate";
    private static final String NAVIGATE_FUNCTION_DESCRIPTION = "(Landroidx/navigation/NavDestination;Landroid/os/Bundle;Landroidx/navigation/NavOptions;Landroidx/navigation/Navigator$Extras;)V";
    private static final String POP_BACKSTACK_FUNCTION_NAME = "popBackStackInternal";
    private static final String POP_BACKSTACK_FUNCTION_DESCRIPTION = "(Landroidx/navigation/Navigator;Landroidx/navigation/NavBackStackEntry;ZLkotlin/jvm/functions/Function1;)V";

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return NAV_CONTROLLER_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateNavControllerNavigateSensor(), this.generateNavControllerPopBackStackSensor());
    }

    private MethodSensor generateNavControllerNavigateSensor() {
        MethodInfo methodInfo = new MethodInfo(NAVIGATE_FUNCTION_NAME, NAVIGATE_FUNCTION_DESCRIPTION, 18, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), "onNavControllerNavigate", "(Landroidx/navigation/NavDestination;)V"), ParameterInstructionProvider.withCustomParameter(25, 0)));
    }

    private MethodSensor generateNavControllerPopBackStackSensor() {
        MethodInfo methodInfo = new MethodInfo(POP_BACKSTACK_FUNCTION_NAME, POP_BACKSTACK_FUNCTION_DESCRIPTION, 18, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), "onNavControllerPopBackStack", "(Landroidx/navigation/NavBackStackEntry;)V"), ParameterInstructionProvider.withCustomParameter(25, 1)));
    }
}

