/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose;

import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.compose.ComposeTransformation;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposePagerStateTransformation
implements ComposeTransformation {
    private static final String CLASS_NAME = "androidx.compose.foundation.pager.PagerState";
    private static final String UPDATE_ON_SCROLL_METHOD_NAME = "updateOnScrollStopped$foundation_release";
    private static final String UPDATE_ON_SCROLL_METHOD_DESCRIPTION = "()V";
    private static final String SCROLL_TO_PAGE_METHOD_NAME = "scrollToPage";
    private static final String SCROLL_TO_PAGE_METHOD_DESCRIPTION = "(IFLkotlin/coroutines/Continuation;)Ljava/lang/Object;";
    private static final String APPLY_METHOD_NAME = "applyMeasureResult$foundation_release";
    private static final String APPLY_METHOD_DESCRIPTION = "(Landroidx/compose/foundation/pager/PagerMeasureResult;)V";

    @Override
    public boolean transformClass(ClassNode node) {
        this.addPageChangedCallbackField(node);
        this.addPreviousPageField(node);
        this.addPageChangedCallbackSetMethod(node);
        return true;
    }

    @Override
    public boolean transformMethod(MethodNode node) {
        if (node.name.equals(UPDATE_ON_SCROLL_METHOD_NAME) && node.desc.equals(UPDATE_ON_SCROLL_METHOD_DESCRIPTION)) {
            this.transformUpdateOnScrollStopped(node);
            return true;
        }
        if (node.name.equals(SCROLL_TO_PAGE_METHOD_NAME) && node.desc.equals(SCROLL_TO_PAGE_METHOD_DESCRIPTION)) {
            this.transformScrollToPage(node);
            return true;
        }
        if (node.name.equals(APPLY_METHOD_NAME) && node.desc.equals(APPLY_METHOD_DESCRIPTION)) {
            this.transformApply(node);
            return true;
        }
        return false;
    }

    @Override
    public boolean exactClassForInstrumentation(String instrumentationClass) {
        return CLASS_NAME.equals(instrumentationClass);
    }

    private void addPageChangedCallbackField(ClassNode node) {
        FieldVisitor visitor = node.visitField(4098, "dyn$pageChangedCallback", "Lcom/dynatrace/android/compose/pager/PageChangedCallback;", null, null);
        visitor.visitEnd();
    }

    private void addPreviousPageField(ClassNode node) {
        FieldVisitor visitor = node.visitField(4098, "dyn$previousPage", "I", null, (Object)0);
        visitor.visitEnd();
    }

    private void addPageChangedCallbackSetMethod(ClassNode node) {
        MethodVisitor visitor = node.visitMethod(4113, "dyn$setPageChangedCallback", "(Lcom/dynatrace/android/compose/pager/PageChangedCallback;)V", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitVarInsn(25, 1);
        visitor.visitFieldInsn(181, "androidx/compose/foundation/pager/PagerState", "dyn$pageChangedCallback", "Lcom/dynatrace/android/compose/pager/PageChangedCallback;");
        visitor.visitInsn(177);
        visitor.visitMaxs(2, 2);
        visitor.visitEnd();
    }

    private void transformUpdateOnScrollStopped(MethodNode node) {
        TransformerUtils.insertAtMethodStart(node, instructions -> {
            InsnList fetchCurrentPageInstructions = new InsnList();
            fetchCurrentPageInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            fetchCurrentPageInstructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/pager/PagerState", "getCurrentPage", "()I", false));
            this.addPageChangedCallbackInstructions(instructions, fetchCurrentPageInstructions, this.getUpdatePreviousPageFieldForSwipe());
        });
    }

    private void transformApply(MethodNode node) {
        TransformerUtils.insertAtMethodExit(node, instructions -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/pager/PagerState", "isScrollInProgress", "()Z", false));
            LabelNode labelNode = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(154, labelNode));
            InsnList fetchCurrentPageInstructions = new InsnList();
            fetchCurrentPageInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            fetchCurrentPageInstructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/pager/PagerState", "getCurrentPage", "()I", false));
            this.addPageChangedCallbackInstructions(instructions, fetchCurrentPageInstructions, this.getUpdatePreviousPageFieldForSwipe());
            instructions.add((AbstractInsnNode)labelNode);
        });
    }

    private void transformScrollToPage(MethodNode node) {
        TransformerUtils.insertAtMethodStart(node, instructions -> {
            InsnList fetchCurrentPageInstructions = new InsnList();
            fetchCurrentPageInstructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            this.addPageChangedCallbackInstructions(instructions, fetchCurrentPageInstructions, this.getUpdatePreviousPageFieldForScroll());
        });
    }

    private void addPageChangedCallbackInstructions(InsnList instructions, InsnList fetchCurrentPageInstructions, InsnList updatePreviousPageInstructions) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, "androidx/compose/foundation/pager/PagerState", "dyn$pageChangedCallback", "Lcom/dynatrace/android/compose/pager/PageChangedCallback;"));
        LabelNode labelNode = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, "androidx/compose/foundation/pager/PagerState", "dyn$pageChangedCallback", "Lcom/dynatrace/android/compose/pager/PageChangedCallback;"));
        instructions.add(fetchCurrentPageInstructions);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, "androidx/compose/foundation/pager/PagerState", "dyn$previousPage", "I"));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "com/dynatrace/android/compose/pager/PageChangedCallback", "invoke", "(II)V", false));
        instructions.add((AbstractInsnNode)labelNode);
        instructions.add(updatePreviousPageInstructions);
    }

    private InsnList getUpdatePreviousPageFieldForSwipe() {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/pager/PagerState", "getCurrentPage", "()I", false));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, "androidx/compose/foundation/pager/PagerState", "dyn$previousPage", "I"));
        return instructions;
    }

    private InsnList getUpdatePreviousPageFieldForScroll() {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, "androidx/compose/foundation/pager/PagerState", "dyn$previousPage", "I"));
        return instructions;
    }
}

