/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.agent;

import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;

public class PresetConfiguration {
    private final boolean certificateValidation;
    private final int graceTime;
    private final int waitTime;
    private final boolean sendEmptyActions;
    private final boolean namePrivacy;
    private final boolean applicationMonitoring;
    private final boolean activityMonitoring;
    private final boolean crashReporting;
    private final boolean webRequestTiming;
    private final String[] monitoredDomains;
    private final String[] monitoredHttpsDomains;
    private final boolean hybridApp;
    private final boolean fileDomainCookies;
    private final boolean debugLogLevel;
    private final boolean autoStart;
    private final boolean userOptIn;
    private final boolean startupLoadBalancing;
    private final InstrumentationFlavor instrumentationFlavor;
    private final boolean isSessionReplayEnabled;
    private final boolean rageTapDetection;

    private PresetConfiguration(Builder builder) {
        this.certificateValidation = builder.certificateValidation;
        this.graceTime = builder.graceTime;
        this.waitTime = builder.waitTime;
        this.sendEmptyActions = builder.sendEmptyActions;
        this.namePrivacy = builder.namePrivacy;
        this.applicationMonitoring = builder.applicationMonitoring;
        this.activityMonitoring = builder.activityMonitoring;
        this.crashReporting = builder.crashReporting;
        this.webRequestTiming = builder.webRequestTiming;
        this.monitoredDomains = builder.monitoredDomains;
        this.monitoredHttpsDomains = builder.monitoredHttpsDomains;
        this.hybridApp = builder.hybridApp;
        this.fileDomainCookies = builder.fileDomainCookies;
        this.debugLogLevel = builder.debugLogLevel;
        this.autoStart = builder.autoStart;
        this.userOptIn = builder.userOptIn;
        this.startupLoadBalancing = builder.startupLoadBalancing;
        this.instrumentationFlavor = builder.instrumentationFlavor;
        this.isSessionReplayEnabled = builder.isSessionReplayEnabled;
        this.rageTapDetection = builder.rageTapDetection;
    }

    public boolean isCertificateValidation() {
        return this.certificateValidation;
    }

    public int getGraceTime() {
        return this.graceTime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public boolean isSendEmptyActions() {
        return this.sendEmptyActions;
    }

    public boolean isNamePrivacy() {
        return this.namePrivacy;
    }

    public boolean isApplicationMonitoring() {
        return this.applicationMonitoring;
    }

    public boolean isActivityMonitoring() {
        return this.activityMonitoring;
    }

    public boolean isCrashReporting() {
        return this.crashReporting;
    }

    public boolean isWebRequestTiming() {
        return this.webRequestTiming;
    }

    public String[] getMonitoredDomains() {
        return this.monitoredDomains;
    }

    public String[] getMonitoredHttpsDomains() {
        return this.monitoredHttpsDomains;
    }

    public boolean isHybridApp() {
        return this.hybridApp;
    }

    public boolean isFileDomainCookies() {
        return this.fileDomainCookies;
    }

    public boolean isDebugLogLevel() {
        return this.debugLogLevel;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isUserOptIn() {
        return this.userOptIn;
    }

    public boolean isStartupLoadBalancing() {
        return this.startupLoadBalancing;
    }

    public InstrumentationFlavor getInstrumentationFlavor() {
        return this.instrumentationFlavor;
    }

    public boolean isSessionReplayEnabled() {
        return this.isSessionReplayEnabled;
    }

    public boolean isRageTapDetection() {
        return this.rageTapDetection;
    }

    public static class Builder {
        private boolean certificateValidation = true;
        private int graceTime = 500;
        private int waitTime = 60000;
        private boolean sendEmptyActions = true;
        private boolean namePrivacy = false;
        private boolean applicationMonitoring = true;
        private boolean activityMonitoring = true;
        private boolean crashReporting = true;
        private boolean webRequestTiming = true;
        private String[] monitoredDomains = new String[0];
        private String[] monitoredHttpsDomains = new String[0];
        private boolean hybridApp = true;
        private boolean fileDomainCookies = true;
        private boolean debugLogLevel = true;
        private boolean autoStart = true;
        private boolean userOptIn = true;
        private boolean startupLoadBalancing = true;
        private InstrumentationFlavor instrumentationFlavor = InstrumentationFlavor.PLAIN;
        private boolean isSessionReplayEnabled = false;
        private boolean rageTapDetection = true;

        public Builder withCertificateValidation(boolean certificateValidation) {
            this.certificateValidation = certificateValidation;
            return this;
        }

        public Builder withGraceTime(int graceTime) {
            this.graceTime = graceTime;
            return this;
        }

        public Builder withWaitTime(int waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public Builder withSendEmptyActions(boolean sendEmptyActions) {
            this.sendEmptyActions = sendEmptyActions;
            return this;
        }

        public Builder withNamePrivacy(boolean namePrivacy) {
            this.namePrivacy = namePrivacy;
            return this;
        }

        public Builder withApplicationMonitoring(boolean applicationMonitoring) {
            this.applicationMonitoring = applicationMonitoring;
            return this;
        }

        public Builder withActivityMonitoring(boolean activityMonitoring) {
            this.activityMonitoring = activityMonitoring;
            return this;
        }

        public Builder withCrashReporting(boolean crashReporting) {
            this.crashReporting = crashReporting;
            return this;
        }

        public Builder withWebRequestTiming(boolean webRequestTiming) {
            this.webRequestTiming = webRequestTiming;
            return this;
        }

        public Builder withMonitoredDomains(String[] monitoredDomains) {
            this.monitoredDomains = monitoredDomains;
            return this;
        }

        public Builder withMonitoredHttpsDomains(String[] monitoredHttpsDomains) {
            this.monitoredHttpsDomains = monitoredHttpsDomains;
            return this;
        }

        public Builder withHybridApp(boolean hybridApp) {
            this.hybridApp = hybridApp;
            return this;
        }

        public Builder withFileDomainCookies(boolean fileDomainCookies) {
            this.fileDomainCookies = fileDomainCookies;
            return this;
        }

        public Builder withDebugLogLevel(boolean debugLogLevel) {
            this.debugLogLevel = debugLogLevel;
            return this;
        }

        public Builder withAutoStart(boolean autoStart) {
            this.autoStart = autoStart;
            return this;
        }

        public Builder withUserOptIn(boolean userOptIn) {
            this.userOptIn = userOptIn;
            return this;
        }

        public Builder withStartupLoadBalancing(boolean startupLoadBalancing) {
            this.startupLoadBalancing = startupLoadBalancing;
            return this;
        }

        public Builder withInstrumentationFlavor(InstrumentationFlavor instrumentationFlavor) {
            this.instrumentationFlavor = instrumentationFlavor;
            return this;
        }

        public Builder withSessionReplayEnabled(boolean sessionReplayEnabled) {
            this.isSessionReplayEnabled = sessionReplayEnabled;
            return this;
        }

        public Builder withRageTapDetection(boolean rageTapDetection) {
            this.rageTapDetection = rageTapDetection;
            return this;
        }

        public PresetConfiguration build() {
            if (this.monitoredDomains == null) {
                throw new IllegalArgumentException("The value for monitoredDomains must not be null");
            }
            if (this.monitoredHttpsDomains == null) {
                throw new IllegalArgumentException("The value for monitoredHttpsDomains must not be null");
            }
            return new PresetConfiguration(this);
        }
    }
}

