/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.agent;

import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavorTranslation;
import com.dynatrace.android.instrumentation.sensor.agent.PresetConfiguration;
import com.dynatrace.android.instrumentation.sensor.agent.SessionReplayComponentProviderSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationPresetSensorFactory {
    public static final String CONFIG_PRESET_CLASS = "com.dynatrace.android.agent.conf.ConfigurationPreset";
    public static final String INSTRUMENTATION_FLAVOR_CLASS = "com.dynatrace.android.agent.conf.InstrumentationFlavor";
    public static final String INSTR_FLAVOR_DESC = "()L" + Utils.dotToSlash("com.dynatrace.android.agent.conf.InstrumentationFlavor") + ";";
    public static final String INT_DESC = "()I";
    public static final String BOOLEAN_DESC = "()Z";
    public static final String STRING_ARRAY_DESC = "()[Ljava/lang/String;";
    public static final String SR_COMPONENT_PROV_DESC = "()Lcom/dynatrace/android/agent/SessionReplayComponentProvider;";
    private final PresetConfiguration presetConfig;

    public ConfigurationPresetSensorFactory(PresetConfiguration config) {
        this.presetConfig = config;
    }

    public SensorGroup<MethodSensor> generateConfigurationPresetSensor() {
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CONFIG_PRESET_CLASS.equals(otherClassInfo.getName()), this.getMethodList());
    }

    private List<MethodSensor> getMethodList() {
        ArrayList<MethodSensor> sensors = new ArrayList<MethodSensor>();
        sensors.add(new MethodSensorImpl(this.findGetter("getGraceTime", INT_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getGraceTime())));
        sensors.add(new MethodSensorImpl(this.findGetter("getWaitTime", INT_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getWaitTime())));
        sensors.add(new MethodSensorImpl(this.findGetter("getApplicationMonitoring", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isApplicationMonitoring())));
        sensors.add(new MethodSensorImpl(this.findGetter("getActivityMonitoring", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isActivityMonitoring())));
        sensors.add(new MethodSensorImpl(this.findGetter("getCertificateValidation", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isCertificateValidation())));
        sensors.add(new MethodSensorImpl(this.findGetter("getSendEmptyActions", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isSendEmptyActions())));
        sensors.add(new MethodSensorImpl(this.findGetter("getNamePrivacy", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isNamePrivacy())));
        sensors.add(new MethodSensorImpl(this.findGetter("getCrashReporting", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isCrashReporting())));
        sensors.add(new MethodSensorImpl(this.findGetter("getWebRequestTiming", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isWebRequestTiming())));
        sensors.add(new MethodSensorImpl(this.findGetter("getMonitoredDomains", STRING_ARRAY_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getMonitoredDomains())));
        sensors.add(new MethodSensorImpl(this.findGetter("getMonitoredHttpsDomains", STRING_ARRAY_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getMonitoredHttpsDomains())));
        sensors.add(new MethodSensorImpl(this.findGetter("getHybridApp", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isHybridApp())));
        sensors.add(new MethodSensorImpl(this.findGetter("getFileDomainCookies", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isFileDomainCookies())));
        sensors.add(new MethodSensorImpl(this.findGetter("getDebugLogLevel", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isDebugLogLevel())));
        sensors.add(new MethodSensorImpl(this.findGetter("getAutoStart", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isAutoStart())));
        sensors.add(new MethodSensorImpl(this.findGetter("getUserOptIn", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isUserOptIn())));
        sensors.add(new MethodSensorImpl(this.findGetter("getStartupLoadBalancing", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isStartupLoadBalancing())));
        sensors.add(new MethodSensorImpl(this.findGetter("getInstrumentationFlavor", INSTR_FLAVOR_DESC), (methodNode, index) -> Utils.replaceEnumGetterInstructions(methodNode.instructions, Utils.dotToSlash(INSTRUMENTATION_FLAVOR_CLASS), new InstrumentationFlavorTranslation().apply(this.presetConfig.getInstrumentationFlavor()))));
        if (this.presetConfig.isSessionReplayEnabled()) {
            sensors.add(new MethodSensorImpl(this.findGetter("getSessionReplayComponentProvider", SR_COMPONENT_PROV_DESC), new SessionReplayComponentProviderSensor()));
        }
        sensors.add(new MethodSensorImpl(this.findGetter("isRageTapDetectionEnabled", BOOLEAN_DESC), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isRageTapDetection())));
        return sensors;
    }

    private MethodInfo findGetter(String name, String desc) {
        return new MethodInfo(name, desc, 1, null, new ArrayList<String>());
    }
}

