/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class SensorGroupImpl<T>
implements SensorGroup<T> {
    private final Predicate<ClassInfo> classMatcher;
    private final List<T> sensors;

    public SensorGroupImpl(ClassInfo classInfo, List<T> sensors) {
        this(classInfo::isAssignableFrom, sensors);
    }

    public SensorGroupImpl(ClassInfo classInfo, T ... sensors) {
        this(classInfo, Arrays.asList(sensors));
    }

    public SensorGroupImpl(Predicate<ClassInfo> classMatcher, List<T> sensors) {
        this.classMatcher = classMatcher;
        this.sensors = sensors;
    }

    public SensorGroupImpl(Predicate<ClassInfo> classMatcher, T ... sensors) {
        this(classMatcher, Arrays.asList(sensors));
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return this.classMatcher.test(classInfo);
    }

    @Override
    public List<T> getSensors() {
        return this.sensors;
    }
}

