/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;

@FunctionalInterface
public interface ParameterInstructionProvider {
    public static ParameterInstructionProvider withThisAndAllParameters(Method method) {
        return ParameterInstructionProvider.withThis().andThen(ParameterInstructionProvider.withAllParameters(method));
    }

    public static ParameterInstructionProvider withThis() {
        return (instructions, startParameterIndex) -> instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
    }

    public static ParameterInstructionProvider withAllParameters(Method method) {
        return ParameterInstructionProvider.withAllParameters(Type.getType((Method)method).getArgumentTypes());
    }

    public static ParameterInstructionProvider withAllParameters(Constructor constructor) {
        return ParameterInstructionProvider.withAllParameters(Type.getType((Constructor)constructor).getArgumentTypes());
    }

    public static ParameterInstructionProvider withAllParameters(Type[] types) {
        return (instructions, startParameterIndex) -> {
            int slotCount = startParameterIndex;
            for (Type paramType : types) {
                instructions.add((AbstractInsnNode)new VarInsnNode(paramType.getOpcode(21), slotCount));
                slotCount += paramType.getSize();
            }
        };
    }

    public static ParameterInstructionProvider withCustomParameter(int opcode, int index) {
        return (instructions, startParameterIndex) -> instructions.add((AbstractInsnNode)new VarInsnNode(opcode, startParameterIndex + index));
    }

    public void addParameterInstructions(InsnList var1, int var2);

    default public ParameterInstructionProvider andThen(ParameterInstructionProvider after) {
        Objects.requireNonNull(after);
        return (instructions, startParameterIndex) -> {
            this.addParameterInstructions(instructions, startParameterIndex);
            after.addParameterInstructions(instructions, startParameterIndex);
        };
    }
}

