/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.classpath;

import com.dynatrace.tools.android.Version;
import com.dynatrace.tools.android.classpath.IllegalClassPathException;
import java.lang.reflect.Method;

public class ClassPathAnalyzer {
    private ClassLoader classLoader;

    public ClassPathAnalyzer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean containsClasses(String ... names) {
        try {
            for (String name : names) {
                Class.forName(name, false, this.classLoader);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean containsCompuwareAgent() {
        return this.containsClasses("com.compuware.android.app.Activity") || this.containsClasses("com.compuware.apm.uem.mobile.android.CompuwareUEM");
    }

    public boolean containsInstrumentationLibraries() {
        return this.containsClasses("com.dynatrace.android.callback.Callback");
    }

    public String determineAgentVersion() {
        try {
            Class<?> clazzAgentVersion = Class.forName("com.dynatrace.android.agent.Version", true, this.classLoader);
            Method method = clazzAgentVersion.getDeclaredMethod("getFullVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void verifyClassPath() {
        if (this.containsCompuwareAgent()) {
            throw new IllegalClassPathException("Invalid agent version detected");
        }
        String agentVersion = this.determineAgentVersion();
        if (agentVersion == null) {
            throw new IllegalClassPathException("OneAgent SDK missing");
        }
        if (!Version.getFullVersion().equals(agentVersion)) {
            throw new IllegalClassPathException("OneAgent SDK version " + agentVersion + " does not match Dynatrace Android Gradle plugin version " + Version.getFullVersion());
        }
        if (!this.containsInstrumentationLibraries()) {
            throw new IllegalClassPathException("Instrumentation libraries are missing");
        }
    }
}

