/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.method.MandatoryMethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MandatoryMethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.LifecycleSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Constants;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class LifecycleTransformerFactory
implements TransformerFactory {
    private static final String APPLICATION = "android.app.Application";
    private static final String ACTIVITY = "android.app.Activity";
    private static final String BUNDLE = "android.os.Bundle";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MandatoryMethodSensor>> methodSensors = new ArrayList<SensorGroup<MandatoryMethodSensor>>();
        methodSensors.add(this.generateActivitySensors(classLoader));
        methodSensors.add(this.generateApplicationSensors(classLoader));
        return new LifecycleSubTransformer("LifecycleTransformer", methodSensors, warningsAsErrors);
    }

    @Override
    public List<String> mandatoryClasses() {
        return Collections.singletonList("com.dynatrace.android.app.Application");
    }

    private SensorGroup<MandatoryMethodSensor> generateActivitySensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> bundle = Class.forName(BUNDLE, false, classLoader);
        Class<?> activity = Class.forName(ACTIVITY, false, classLoader);
        Method onCreate = activity.getDeclaredMethod("onCreate", bundle);
        Method onPostCreate = activity.getDeclaredMethod("onPostCreate", bundle);
        Method onStart = activity.getDeclaredMethod("onStart", new Class[0]);
        Method onRestart = activity.getDeclaredMethod("onRestart", new Class[0]);
        Method onResume = activity.getDeclaredMethod("onResume", new Class[0]);
        Method onPostResume = activity.getDeclaredMethod("onPostResume", new Class[0]);
        Method onPause = activity.getDeclaredMethod("onPause", new Class[0]);
        Method onStop = activity.getDeclaredMethod("onStop", new Class[0]);
        Method onDestroy = activity.getDeclaredMethod("onDestroy", new Class[0]);
        Class<?> callback = Class.forName(Constants.CALLBACK_DYNATRACE, false, classLoader);
        Method instr_onCreate = callback.getDeclaredMethod("onCreate", activity);
        Method instr_onPostCreate = callback.getDeclaredMethod("onPostCreate", activity);
        Method instr_onStart = callback.getDeclaredMethod("onStart", activity);
        Method instr_onRestart = callback.getDeclaredMethod("onRestart", activity);
        Method instr_onResume = callback.getDeclaredMethod("onResume", activity);
        Method instr_onPostResume = callback.getDeclaredMethod("onPostResume", activity);
        Method instr_onPause = callback.getDeclaredMethod("onPause", activity);
        Method instr_onStop = callback.getDeclaredMethod("onStop", activity);
        Method instr_onDestroy = callback.getDeclaredMethod("onDestroy", activity);
        return new SensorGroupImpl<MandatoryMethodSensor>("ActivitySensor", this.lifecycleFilter(activity), new MandatoryMethodSensorImpl(onCreate, new StartMethodTransformation(instr_onCreate, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onPostCreate, new StartMethodTransformation(instr_onPostCreate, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onStart, new StartMethodTransformation(instr_onStart, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onRestart, new StartMethodTransformation(instr_onRestart, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onResume, new StartMethodTransformation(instr_onResume, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onPostResume, new StartMethodTransformation(instr_onPostResume, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onPause, new StartMethodTransformation(instr_onPause, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onStop, new StartMethodTransformation(instr_onStop, ParameterInstructionProvider.withThis())), new MandatoryMethodSensorImpl(onDestroy, new StartMethodTransformation(instr_onDestroy, ParameterInstructionProvider.withThis())));
    }

    private SensorGroup<MandatoryMethodSensor> generateApplicationSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> application = Class.forName(APPLICATION, false, classLoader);
        Method onCreate = application.getDeclaredMethod("onCreate", new Class[0]);
        Class<?> callback = Class.forName(Constants.CALLBACK_DYNATRACE, false, classLoader);
        Method instr_onCreate = callback.getDeclaredMethod("onCreate", application);
        return new SensorGroupImpl<MandatoryMethodSensor>("ApplicationSensor", this.lifecycleFilter(application), new MandatoryMethodSensorImpl(onCreate, new StartMethodTransformation(instr_onCreate, ParameterInstructionProvider.withThis())));
    }

    private Predicate<Class<?>> lifecycleFilter(Class<?> classFilter) {
        return clazz -> !Modifier.isAbstract(clazz.getModifiers()) && classFilter.isAssignableFrom((Class<?>)clazz);
    }
}

