/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.agent;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationMode;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationModeTranslation;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class ConfigurationPresetSensorFactory {
    public static final String CONFIG_PRESET_CLASS = "com.dynatrace.android.agent.conf.ConfigurationPreset";
    public static final String INSTRUMENTATION_MODE_CLASS = "com.dynatrace.android.agent.conf.InstrumentationMode";
    private PresetConfiguration presetConfig;

    public ConfigurationPresetSensorFactory(PresetConfiguration config) {
        this.presetConfig = config;
    }

    public SensorGroup<MethodSensor> generateConfigurationPresetSensor(ClassLoader classLoader) throws Exception {
        Class<?> configPresetClass = Class.forName(CONFIG_PRESET_CLASS, false, classLoader);
        return new SensorGroupImpl<MethodSensor>("ConfigurationPresetSensor", otherClass -> configPresetClass == otherClass, this.getMethodList(classLoader));
    }

    private List<MethodSensor> getMethodList(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> agentInstrumentationModeClass = Class.forName(INSTRUMENTATION_MODE_CLASS, false, classLoader);
        Enum<Enum<?>> translatedInstrumentationMode = Utils.translateEnum(agentInstrumentationModeClass, this.presetConfig.instrumentationMode, new InstrumentationModeTranslation());
        return Arrays.asList(new MethodSensorImpl(this.findGetter("getGraceTime", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.graceTime)), new MethodSensorImpl(this.findGetter("getWaitTime", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.waitTime)), new MethodSensorImpl(this.findGetter("getApplicationMonitoring", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.applicationMonitoring)), new MethodSensorImpl(this.findGetter("getActivityMonitoring", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.activityMonitoring)), new MethodSensorImpl(this.findGetter("getCertificateValidation", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.certificateValidation)), new MethodSensorImpl(this.findGetter("getSendEmptyActions", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.sendEmptyActions)), new MethodSensorImpl(this.findGetter("getCrashReporting", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.crashReporting)), new MethodSensorImpl(this.findGetter("getWebRequestTiming", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.webRequestTiming)), new MethodSensorImpl(this.findGetter("getMonitoredDomains", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.monitoredDomains)), new MethodSensorImpl(this.findGetter("getNoSendInBg", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.noSendInBg)), new MethodSensorImpl(this.findGetter("getHybridApp", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.hybridApp)), new MethodSensorImpl(this.findGetter("getDebugLogLevel", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.debugLogLevel)), new MethodSensorImpl(this.findGetter("getAutoStart", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.autoStart)), new MethodSensorImpl(this.findGetter("getUserOptIn", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.userOptIn)), new MethodSensorImpl(this.findGetter("getStartupLoadBalancing", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.startupLoadBalancing)), new MethodSensorImpl(this.findGetter("getInstrumentationMode", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, translatedInstrumentationMode)));
    }

    private Method findGetter(String name, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(CONFIG_PRESET_CLASS, false, classLoader).getDeclaredMethod(name, new Class[0]);
    }

    public static class PresetConfiguration {
        public final boolean certificateValidation;
        public final int graceTime;
        public final int waitTime;
        public final boolean sendEmptyActions;
        public final boolean applicationMonitoring;
        public final boolean activityMonitoring;
        public final boolean crashReporting;
        public final boolean webRequestTiming;
        public final String[] monitoredDomains;
        public final boolean noSendInBg;
        public final boolean hybridApp;
        public final boolean debugLogLevel;
        public final boolean autoStart;
        public final boolean userOptIn;
        public final boolean startupLoadBalancing;
        public final InstrumentationMode instrumentationMode;

        public PresetConfiguration(boolean certificateValidation, int graceTime, int waitTime, boolean sendEmptyActions, boolean applicationMonitoring, boolean activityMonitoring, boolean crashReporting, boolean webRequestTiming, String[] monitoredDomains, boolean noSendInBg, boolean hybridApp, boolean debugLogLevel, boolean autoStart, boolean userOptIn, boolean startupLoadBalancing, InstrumentationMode instrumentationMode) {
            this.certificateValidation = certificateValidation;
            this.graceTime = graceTime;
            this.waitTime = waitTime;
            this.sendEmptyActions = sendEmptyActions;
            this.applicationMonitoring = applicationMonitoring;
            this.activityMonitoring = activityMonitoring;
            this.crashReporting = crashReporting;
            this.webRequestTiming = webRequestTiming;
            if (monitoredDomains == null) {
                throw new IllegalArgumentException("The value for monitoredDomains must not be null");
            }
            this.monitoredDomains = monitoredDomains;
            this.noSendInBg = noSendInBg;
            this.hybridApp = hybridApp;
            this.debugLogLevel = debugLogLevel;
            this.autoStart = autoStart;
            this.userOptIn = userOptIn;
            this.startupLoadBalancing = startupLoadBalancing;
            this.instrumentationMode = instrumentationMode;
        }
    }
}

