/*
 * Copyright 2015 Dynatrace
 *
 * Licensed under the Dynatrace SaaS terms of service (the "License");
 * You may obtain a copy of the License at
 *
 *      https://ruxit.com/eula/saas/#terms-of-service
 */
package com.dynatrace.tools.android;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Configuration to define instrumentation behavior.
 */
class ApplicationFlavor {
	/**
	 * Name of the flavor
	 */
	private final String name;

	/**
	 * Application id assigned in dynatrace
	 */
	private String applicationId;

	/**
	 * Id of the environment in dynatrace
	 */
	private String environmentId;

	/**
	 * cluster to report data to
	 */
	private String cluster = "https://live.dynatrace.com";

	/**
	 * beaconURL id in dynatrace
	 */
	private String beaconURL;

	/**
	 * app mon host path to monitor beacon
	 */
	private String startupPath;

	/**
	 * Additional properties passed to the instrumentor
	 */
	private Map<String, String> agentProperties = new LinkedHashMap<>();

	ApplicationFlavor(String name) {
		this.name = name.toLowerCase();
	}

	public void applicationId(String applicationId) {
		this.applicationId = applicationId;
	}

	public void environmentId(String environmentId) {
		this.environmentId = environmentId;
	}

	public void cluster(String cluster) {
		this.cluster = cluster;
	}

	public void beaconURL(String beaconURL) {
		this.beaconURL = beaconURL;
	}

	public void startupPath(String startupPath) {
		this.startupPath = startupPath;
	}

	public void agentProperties(Map<String, String> agentProperties) {
		this.agentProperties.putAll(agentProperties);
	}

	public String getName() {
		return name;
	}

	public String getApplicationId() {
		return applicationId;
	}

	public String getEnvironmentId() {
		return environmentId;
	}

	public String getBeaconURL() {
		return beaconURL;
	}

	public String getCluster() {
		return cluster;
	}

	public String getStartupPath() {
		return startupPath;
	}

	public Map<String, String> getAgentProperties() {
		return agentProperties;
	}
}
