/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.builder.model.SigningConfig;
import com.dynatrace.tools.android.AndroidPluginVersion;
import com.dynatrace.tools.android.AutoInstrumentTask;
import com.dynatrace.tools.android.DynatraceConfig;
import java.io.File;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;
import org.jetbrains.annotations.NotNull;

public class DynatraceAndroidPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;

    @Inject
    public DynatraceAndroidPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(@NotNull Project project) {
        DynatraceConfig config = (DynatraceConfig)this.instantiator.newInstance(DynatraceConfig.class, new Object[]{project});
        project.getExtensions().add("dynatrace", (Object)config);
        this.createAutoInstrumentTasks(project);
    }

    private void createAutoInstrumentTasks(final Project project) {
        final DefaultTask prepareApkit = (DefaultTask)project.getTasks().create("prepareApkit", DefaultTask.class);
        prepareApkit.doLast(task -> task.getLogger().info("prepare {}", (Object)((DynatraceConfig)project.getExtensions().getByType(DynatraceConfig.class)).apkitDir()));
        AppExtension appExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        appExtension.getApplicationVariants().all((Action)new Action<ApplicationVariant>(){

            public void execute(final @NotNull ApplicationVariant applicationVariant) {
                Iterable collection;
                applicationVariant.getPreBuild().dependsOn(new Object[]{prepareApkit});
                String capitalizedFlavorName = applicationVariant.getName().substring(0, 1).toUpperCase() + applicationVariant.getName().substring(1);
                try {
                    Method methodOutputs = ApplicationVariant.class.getMethod("getOutputs", new Class[0]);
                    methodOutputs.setAccessible(true);
                    collection = (Iterable)methodOutputs.invoke((Object)applicationVariant, new Object[0]);
                }
                catch (Exception e) {
                    throw new GradleException("Failed to read: variant outputs", (Throwable)e);
                }
                for (BaseVariantOutput baseVariantOutput : collection) {
                    PackageApplication taskPackage;
                    final ApkVariantOutput apkVariantOutput = (ApkVariantOutput)baseVariantOutput;
                    final AndroidPluginVersion androidPluginVersion = DynatraceAndroidPlugin.this.determineAndroidPluginVersion(apkVariantOutput);
                    try {
                        Method methodPackage = ApkVariantOutput.class.getDeclaredMethod("getPackageApplication", new Class[0]);
                        taskPackage = (PackageApplication)methodPackage.invoke((Object)apkVariantOutput, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new GradleException("Failed to get PackageApplication task", (Throwable)e);
                    }
                    final DynatraceConfig config = (DynatraceConfig)project.getExtensions().getByType(DynatraceConfig.class);
                    AutoInstrumentTask instrumentTask = (AutoInstrumentTask)project.getTasks().create("autoInstrument" + capitalizedFlavorName, AutoInstrumentTask.class, (Action)new Action<AutoInstrumentTask>(){

                        public void execute(@NotNull AutoInstrumentTask autoInstrumentTask) {
                            autoInstrumentTask.setSigningConfig((SigningConfig)taskPackage.getSigningConfig());
                            autoInstrumentTask.setAndroidPluginVersion(androidPluginVersion);
                            autoInstrumentTask.setPackageTask(taskPackage);
                            autoInstrumentTask.conventionMapping("outputFile", () -> new File(autoInstrumentTask.getTemporaryDir(), (androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_0) ? apkVariantOutput.getOutputFile() : taskPackage.getOutputFile()).getName()));
                            autoInstrumentTask.conventionMapping("apkFile", () -> androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_0) ? apkVariantOutput.getOutputFile() : taskPackage.getOutputFile());
                            autoInstrumentTask.conventionMapping("apkitDir", config::apkitDir);
                            autoInstrumentTask.conventionMapping("applicationId", config.findProductFlavor(applicationVariant.getFlavorName())::getApplicationId);
                            autoInstrumentTask.conventionMapping("environmentId", config.findProductFlavor(applicationVariant.getFlavorName())::getEnvironmentId);
                            autoInstrumentTask.conventionMapping("cluster", config.findProductFlavor(applicationVariant.getFlavorName())::getCluster);
                            autoInstrumentTask.conventionMapping("startupPath", config.findProductFlavor(applicationVariant.getFlavorName())::getStartupPath);
                            autoInstrumentTask.conventionMapping("agentProperties", config.findProductFlavor(applicationVariant.getFlavorName())::getAgentProperties);
                        }
                    });
                    if (androidPluginVersion == AndroidPluginVersion.VERSION_1_5) {
                        try {
                            Method methodZipAlign = ApkVariantOutput.class.getDeclaredMethod("getZipAlign", new Class[0]);
                            methodZipAlign.setAccessible(true);
                            Object zipAlign = methodZipAlign.invoke((Object)apkVariantOutput, new Object[0]);
                            Method methodInputFile = zipAlign.getClass().getDeclaredMethod("setInputFile", File.class);
                            methodInputFile.setAccessible(true);
                            methodInputFile.invoke(zipAlign, instrumentTask.getOutputFile());
                        }
                        catch (Exception e) {
                            throw new GradleException("Cannot set input file for task ZipAlign", (Throwable)e);
                        }
                    }
                    taskPackage.finalizedBy(new Object[]{instrumentTask});
                }
            }
        });
    }

    private AndroidPluginVersion determineAndroidPluginVersion(ApkVariantOutput apkVariantOutput) {
        try {
            Class.forName("com.android.build.gradle.internal.tasks.BaseTask");
        }
        catch (ClassNotFoundException e) {
            return AndroidPluginVersion.VERSION_3_1;
        }
        try {
            Class.forName("com.android.build.gradle.tasks.ZipAlign");
        }
        catch (ClassNotFoundException e) {
            return AndroidPluginVersion.VERSION_3_0;
        }
        try {
            Method methodZipAlign = ApkVariantOutput.class.getDeclaredMethod("getZipAlign", new Class[0]);
            methodZipAlign.setAccessible(true);
            Object zipAlign = methodZipAlign.invoke((Object)apkVariantOutput, new Object[0]);
            if (zipAlign != null) {
                return AndroidPluginVersion.VERSION_1_5;
            }
        }
        catch (Exception e) {
            throw new GradleException("Cannot access task ZipAlign", (Throwable)e);
        }
        try {
            Class.forName("com.android.builder.packaging.NativeLibrariesPackagingMode");
            return AndroidPluginVersion.VERSION_2_2;
        }
        catch (ClassNotFoundException e) {
            return AndroidPluginVersion.VERSION_2_3;
        }
    }
}

