/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.oneagent.sdk.impl;

import com.dynatrace.oneagent.sdk.api.OneAgentSDK;
import com.dynatrace.oneagent.sdk.impl.SDKInstanceProvider;
import com.dynatrace.oneagent.sdk.impl.noop.OneAgentSDKNoop;
import com.dynatrace.oneagent.sdk.impl.proxy.OneAgentSDKProxy;
import com.dynatrace.oneagent.sdk.impl.proxy.SDK2AgentInternalApiProxy;

public class OneAgentSDKFactoryImpl {
    static final int oneSdkMajor = 1;
    static final int oneSdkMinor = 8;
    static final int oneSdkFix = 0;
    public static final boolean debugOneAgentSdkStub = Boolean.parseBoolean(System.getProperty("com.dynatrace.oneagent.sdk.debug", "false"));

    private static OneAgentSDK createOneSDK() {
        Object agentApiImpl = SDKInstanceProvider.create(1, 8, 0);
        if (agentApiImpl == null) {
            if (debugOneAgentSdkStub) {
                OneAgentSDKFactoryImpl.logDebug("- no OneAgent present or OneAgent declined to work with OneAgentSdk version 1.8.0");
            }
            return new OneAgentSDKNoop();
        }
        try {
            SDK2AgentInternalApiProxy agentApi = new SDK2AgentInternalApiProxy(agentApiImpl);
            Object agentSdkImpl = agentApi.oneAgentSDKFactory_createSdk();
            if (agentSdkImpl != null) {
                return new OneAgentSDKProxy(agentApi, agentSdkImpl);
            }
            if (debugOneAgentSdkStub) {
                OneAgentSDKFactoryImpl.logDebug("- OneAgent failed to provide sdk object.");
            }
            return new OneAgentSDKNoop();
        }
        catch (Throwable e) {
            if (debugOneAgentSdkStub) {
                OneAgentSDKFactoryImpl.logDebug("- failed to contact OneAgent: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return new OneAgentSDKNoop();
        }
    }

    public static OneAgentSDK createInstance() {
        return OneAgentSDKFactoryImpl.createOneSDK();
    }

    public static void logDebug(String msg) {
        System.out.println("[onesdk    ] " + msg);
    }
}

