/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.MetricLineConstants;
import com.dynatrace.metric.util.NormalizationResult;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class NormalizationWarnThenDebugLogger {
    private final AtomicBoolean metricKeyNormalizationWarnLogged = new AtomicBoolean(false);
    private final AtomicBoolean dimensionKeyNormalizationWarnLogged = new AtomicBoolean(false);
    private final AtomicBoolean dimensionValueNormalizationWarnLogged = new AtomicBoolean(false);
    private static final String METRIC_KEY_AND_DIMENSION_KEY_TEMPLATE = "%s | %s";
    private final Logger logger;

    NormalizationWarnThenDebugLogger(Logger logger) {
        this.logger = logger;
    }

    void logMetricKeyMessage(NormalizationResult normalizationResult) {
        if (this.metricKeyNormalizationWarnLogged.compareAndSet(false, true)) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(String.format("%s. Further normalization logs for data of the same type will be logged at debug level.", normalizationResult.getMessage()));
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(normalizationResult.getMessage());
        }
    }

    public void logDimensionKeyMessage(String metricKey, NormalizationResult normalizationResult) {
        if (this.dimensionKeyNormalizationWarnLogged.compareAndSet(false, true)) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(String.format(MetricLineConstants.ValidationMessages.THROTTLE_INFO_WITH_PREFIX, metricKey, normalizationResult.getMessage()));
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(String.format("[%s] %s", metricKey, normalizationResult.getMessage()));
        }
    }

    public void logDimensionValueMessage(String metricKey, String dimensionKey, NormalizationResult normalizationResult) {
        if (this.dimensionValueNormalizationWarnLogged.compareAndSet(false, true)) {
            if (this.logger.isLoggable(Level.WARNING)) {
                String identifier = String.format(METRIC_KEY_AND_DIMENSION_KEY_TEMPLATE, metricKey, dimensionKey);
                this.logger.warning(String.format(MetricLineConstants.ValidationMessages.THROTTLE_INFO_WITH_PREFIX, identifier, normalizationResult.getMessage()));
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            String identifier = String.format(METRIC_KEY_AND_DIMENSION_KEY_TEMPLATE, metricKey, dimensionKey);
            this.logger.fine(String.format("[%s] %s", identifier, normalizationResult.getMessage()));
        }
    }
}

