/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.Dimension;
import com.dynatrace.metric.util.DynatraceMetadataEnricher;
import com.dynatrace.metric.util.Normalize;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public final class DimensionList {
    private static final Logger logger = Logger.getLogger(DimensionList.class.getName());
    private final List<Dimension> dimensions;

    private DimensionList(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public static DimensionList fromCollection(Collection<Dimension> dimensions) {
        return new DimensionList(Normalize.dimensionList(dimensions));
    }

    public static DimensionList create(Dimension ... dimensions) {
        return DimensionList.fromCollection(Arrays.asList(dimensions));
    }

    @Deprecated
    public static DimensionList fromOneAgentMetadata() {
        return DimensionList.fromDynatraceMetadata();
    }

    public static DimensionList fromDynatraceMetadata() {
        return DimensionList.fromCollection(DynatraceMetadataEnricher.getDynatraceMetadata());
    }

    public boolean isEmpty() {
        return this.dimensions.isEmpty();
    }

    public static DimensionList merge(DimensionList ... dimensionLists) {
        if (dimensionLists == null) {
            return DimensionList.create(new Dimension[0]);
        }
        HashMap<String, Dimension> dimensionMap = new HashMap<String, Dimension>();
        for (DimensionList dl : dimensionLists) {
            if (dl == null) continue;
            for (Dimension dimension : dl.dimensions) {
                if (dimension.getKey() == null || dimension.getKey().isEmpty()) {
                    logger.warning("skipping empty key");
                    continue;
                }
                dimensionMap.put(dimension.getKey(), dimension);
            }
        }
        return DimensionList.fromCollection(dimensionMap.values());
    }

    public Collection<Dimension> getDimensions() {
        return Collections.unmodifiableList(this.dimensions);
    }

    String serialize() {
        if (this.dimensions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean firstIteration = true;
        for (Dimension dimension : this.dimensions) {
            if (!firstIteration) {
                builder.append(",");
            } else {
                firstIteration = false;
            }
            builder.append(dimension.serialize());
        }
        return builder.toString();
    }
}

