/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.Normalize;
import java.util.Objects;

public final class Dimension {
    private final String key;
    private final String value;

    private Dimension(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static Dimension create(String key, String value) {
        return new Dimension(key, value);
    }

    public String toString() {
        return this.serialize();
    }

    String serialize() {
        return String.format("%s=%s", this.key, Normalize.escapeDimensionValue(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        return Objects.equals(this.key, dimension.key) && Objects.equals(this.value, dimension.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

