/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.repositories;

import com.dynatrace.android.sessionreplay.data.daos.SessionDAO;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.android.sessionreplay.model.SessionState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0011\u0012\u0004\u0012\u00020\b0\u0006J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0013\u001a\u00020\rJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0013\u001a\u00020\rJ\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/dynatrace/android/sessionreplay/data/repositories/SessionRepository;", "", "sessionDAO", "Lcom/dynatrace/android/sessionreplay/data/daos/SessionDAO;", "(Lcom/dynatrace/android/sessionreplay/data/daos/SessionDAO;)V", "create", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/model/Session;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "session", "delete", "", "sessionId", "", "deleteAll", "get", "getAll", "", "setCrashed", "id", "setPartiallySent", "updateLastEventTimestamp", "lastEventTimestamp", "", "updateState", "state", "Lcom/dynatrace/android/sessionreplay/model/SessionState;", "updateVisitId", "oldVisitId", "newVisitId", "datalayer_release"})
public final class SessionRepository {
    @NotNull
    private final SessionDAO sessionDAO;

    public SessionRepository(@NotNull SessionDAO sessionDAO) {
        Intrinsics.checkNotNullParameter((Object)sessionDAO, (String)"sessionDAO");
        this.sessionDAO = sessionDAO;
    }

    @NotNull
    public final Result<Session, DataError> get(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        return this.sessionDAO.get(sessionId);
    }

    @NotNull
    public final Result<List<Session>, DataError> getAll() {
        return this.sessionDAO.getAll();
    }

    @NotNull
    public final Result<Session, DataError> create(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.sessionDAO.create(session);
    }

    public final void delete(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.sessionDAO.delete(sessionId);
    }

    @NotNull
    public final Result<String, DataError> updateVisitId(@NotNull String oldVisitId, @NotNull String newVisitId) {
        Intrinsics.checkNotNullParameter((Object)oldVisitId, (String)"oldVisitId");
        Intrinsics.checkNotNullParameter((Object)newVisitId, (String)"newVisitId");
        return this.sessionDAO.updateVisitId(oldVisitId, newVisitId);
    }

    @NotNull
    public final Result<String, DataError> setPartiallySent(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionDAO.updateIsPartiallySent(id, true);
    }

    @NotNull
    public final Result<String, DataError> setCrashed(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionDAO.updateDidCrash(id, true);
    }

    @NotNull
    public final Result<String, DataError> updateLastEventTimestamp(@NotNull String id, long lastEventTimestamp) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionDAO.updateLastEventTimestamp(id, lastEventTimestamp);
    }

    @NotNull
    public final Result<String, DataError> updateState(@NotNull String sessionId, @NotNull SessionState state) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.sessionDAO.updateState(sessionId, state);
    }

    public final void deleteAll() {
        this.sessionDAO.deleteAll();
    }
}

