/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.user;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.DeleteEventsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.GetAllEventsByVisitIdUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.purge.PurgeSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.CleanSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.LogSessionScreenshotCountUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.RefreshSessionEndTimeUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.SetSessionCrashedUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.syncjob.CreateSyncJobsResult;
import com.dynatrace.android.sessionreplay.core.usecases.syncjob.CreateSyncJobsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.user.ProcessCrashUseCaseKt;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/user/ProcessCrashUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "", "", "purgeSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/purge/PurgeSessionUseCase;", "createSyncJobsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/syncjob/CreateSyncJobsUseCase;", "getSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;", "cleanSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;", "deleteEventsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/DeleteEventsUseCase;", "setSessionCrashedUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/SetSessionCrashedUseCase;", "refreshSessionEndTimeUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/RefreshSessionEndTimeUseCase;", "getAllEventsByVisitIdUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;", "logSessionScreenshotCountUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/purge/PurgeSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/syncjob/CreateSyncJobsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/event/DeleteEventsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/SetSessionCrashedUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/RefreshSessionEndTimeUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/LogSessionScreenshotCountUseCase;)V", "processCrash", "session", "Lcom/dynatrace/android/sessionreplay/model/Session;", "start", "visitId", "agent_release"})
@SourceDebugExtension(value={"SMAP\nProcessCrashUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessCrashUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/user/ProcessCrashUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n*L\n1#1,70:1\n33#2,4:71\n*S KotlinDebug\n*F\n+ 1 ProcessCrashUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/user/ProcessCrashUseCase\n*L\n31#1:71,4\n*E\n"})
public final class ProcessCrashUseCase
implements UseCase<String, Unit> {
    @NotNull
    private final PurgeSessionUseCase purgeSessionUseCase;
    @NotNull
    private final CreateSyncJobsUseCase createSyncJobsUseCase;
    @NotNull
    private final GetSessionUseCase getSessionUseCase;
    @NotNull
    private final CleanSessionUseCase cleanSessionUseCase;
    @NotNull
    private final DeleteEventsUseCase deleteEventsUseCase;
    @NotNull
    private final SetSessionCrashedUseCase setSessionCrashedUseCase;
    @NotNull
    private final RefreshSessionEndTimeUseCase refreshSessionEndTimeUseCase;
    @NotNull
    private final GetAllEventsByVisitIdUseCase getAllEventsByVisitIdUseCase;
    @NotNull
    private final LogSessionScreenshotCountUseCase logSessionScreenshotCountUseCase;

    public ProcessCrashUseCase(@NotNull PurgeSessionUseCase purgeSessionUseCase, @NotNull CreateSyncJobsUseCase createSyncJobsUseCase, @NotNull GetSessionUseCase getSessionUseCase, @NotNull CleanSessionUseCase cleanSessionUseCase, @NotNull DeleteEventsUseCase deleteEventsUseCase, @NotNull SetSessionCrashedUseCase setSessionCrashedUseCase, @NotNull RefreshSessionEndTimeUseCase refreshSessionEndTimeUseCase, @NotNull GetAllEventsByVisitIdUseCase getAllEventsByVisitIdUseCase, @NotNull LogSessionScreenshotCountUseCase logSessionScreenshotCountUseCase) {
        Intrinsics.checkNotNullParameter((Object)purgeSessionUseCase, (String)"purgeSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)createSyncJobsUseCase, (String)"createSyncJobsUseCase");
        Intrinsics.checkNotNullParameter((Object)getSessionUseCase, (String)"getSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)cleanSessionUseCase, (String)"cleanSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteEventsUseCase, (String)"deleteEventsUseCase");
        Intrinsics.checkNotNullParameter((Object)setSessionCrashedUseCase, (String)"setSessionCrashedUseCase");
        Intrinsics.checkNotNullParameter((Object)refreshSessionEndTimeUseCase, (String)"refreshSessionEndTimeUseCase");
        Intrinsics.checkNotNullParameter((Object)getAllEventsByVisitIdUseCase, (String)"getAllEventsByVisitIdUseCase");
        Intrinsics.checkNotNullParameter((Object)logSessionScreenshotCountUseCase, (String)"logSessionScreenshotCountUseCase");
        this.purgeSessionUseCase = purgeSessionUseCase;
        this.createSyncJobsUseCase = createSyncJobsUseCase;
        this.getSessionUseCase = getSessionUseCase;
        this.cleanSessionUseCase = cleanSessionUseCase;
        this.deleteEventsUseCase = deleteEventsUseCase;
        this.setSessionCrashedUseCase = setSessionCrashedUseCase;
        this.refreshSessionEndTimeUseCase = refreshSessionEndTimeUseCase;
        this.getAllEventsByVisitIdUseCase = getAllEventsByVisitIdUseCase;
        this.logSessionScreenshotCountUseCase = logSessionScreenshotCountUseCase;
    }

    @Override
    public void start(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        Result<Session, DataError> this_$iv = this.getSessionUseCase.start(visitId);
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            Session session = (Session)((Result.Success)this_$iv).getData();
            boolean bl = false;
            if (ProcessCrashUseCaseKt.access$hasToReportCrash(session)) {
                this.processCrash(session);
            } else {
                this.cleanSessionUseCase.start(visitId);
            }
        }
    }

    private final void processCrash(Session session) {
        String visitId = session.getVisitId();
        if (session.isTrimCrash()) {
            this.purgeSessionUseCase.start(visitId);
        }
        List<Event> eventsAfterPurge = this.getAllEventsByVisitIdUseCase.start(visitId);
        Result<CreateSyncJobsResult, DataError> result = this.createSyncJobsUseCase.start(visitId);
        int createSyncJobCount = result instanceof Result.Success ? ((CreateSyncJobsResult)((Result.Success)result).getData()).getScreenshotJobCount() : 0;
        this.logSessionScreenshotCountUseCase.start(new LogSessionScreenshotCountUseCase.Params(visitId, eventsAfterPurge, createSyncJobCount));
        this.refreshSessionEndTimeUseCase.start(session);
        this.deleteEventsUseCase.start(new ArrayList<Event>((Collection)eventsAfterPurge));
        this.setSessionCrashedUseCase.start(session.getVisitId());
    }
}

