/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.trim;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.usecases.UseCaseNoResult;
import com.dynatrace.android.sessionreplay.core.usecases.event.DeleteEventsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.GetAllEventsByVisitIdUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.SaveLogUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.trim.TrimEventsUseCase;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Log;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimSessionUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCaseNoResult;", "", "getEventsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;", "trimEventsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase;", "deleteEventsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/DeleteEventsUseCase;", "saveLogUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/trim/TrimEventsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/event/DeleteEventsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;)V", "start", "", "visitId", "agent_release"})
@SourceDebugExtension(value={"SMAP\nTrimSessionUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrimSessionUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/trim/TrimSessionUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n*L\n1#1,34:1\n33#2,4:35\n*S KotlinDebug\n*F\n+ 1 TrimSessionUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/trim/TrimSessionUseCase\n*L\n23#1:35,4\n*E\n"})
public final class TrimSessionUseCase
implements UseCaseNoResult<String> {
    @NotNull
    private final GetAllEventsByVisitIdUseCase getEventsUseCase;
    @NotNull
    private final TrimEventsUseCase trimEventsUseCase;
    @NotNull
    private final DeleteEventsUseCase deleteEventsUseCase;
    @NotNull
    private final SaveLogUseCase saveLogUseCase;

    public TrimSessionUseCase(@NotNull GetAllEventsByVisitIdUseCase getEventsUseCase, @NotNull TrimEventsUseCase trimEventsUseCase, @NotNull DeleteEventsUseCase deleteEventsUseCase, @NotNull SaveLogUseCase saveLogUseCase) {
        Intrinsics.checkNotNullParameter((Object)getEventsUseCase, (String)"getEventsUseCase");
        Intrinsics.checkNotNullParameter((Object)trimEventsUseCase, (String)"trimEventsUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteEventsUseCase, (String)"deleteEventsUseCase");
        Intrinsics.checkNotNullParameter((Object)saveLogUseCase, (String)"saveLogUseCase");
        this.getEventsUseCase = getEventsUseCase;
        this.trimEventsUseCase = trimEventsUseCase;
        this.deleteEventsUseCase = deleteEventsUseCase;
        this.saveLogUseCase = saveLogUseCase;
    }

    @Override
    public void start(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        List<Event> sessionEvents = this.getEventsUseCase.start(visitId);
        if (sessionEvents.isEmpty()) {
            return;
        }
        Result<TrimEventsUseCase.TrimEventsResult, Unit> this_$iv = this.trimEventsUseCase.start(new TrimEventsUseCase.TrimEventsParams(sessionEvents, 0L, 0L, 6, null));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            TrimEventsUseCase.TrimEventsResult result = (TrimEventsUseCase.TrimEventsResult)((Result.Success)this_$iv).getData();
            boolean bl = false;
            if (result.getToRemoveEvents().isEmpty()) {
                return;
            }
            this.deleteEventsUseCase.start(new ArrayList<Event>((Collection)result.getToRemoveEvents()));
            String logMessage = "Session trimmed -> time: " + result.getTrimmedTime() + " ms, size: " + result.getTrimmedSize() + " bytes, removed " + result.getToRemoveEvents().size() + " events";
            DTLogger.INSTANCE.sync(logMessage);
            this.saveLogUseCase.start(new SaveLogUseCase.Params(new Log(visitId, logMessage, 0L, null, 12, null)));
        }
    }
}

