/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sync;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.SessionErrorHandler;
import com.dynatrace.android.sessionreplay.core.manager.model.SelfMonitoringFlags;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.BuildSelfMonitoringBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.SendBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.model.BeaconResult;
import com.dynatrace.android.sessionreplay.core.usecases.selfmonitor.DeleteSelfMonitoringDataUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.selfmonitor.GetSessionSelfMonitoringDataUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.selfmonitor.model.SelfMonitoringBeaconWithDataList;
import com.dynatrace.android.sessionreplay.model.APIError;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.selfmonitoring.SelfMonitoringSerializedData;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u001d\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/model/BeaconResult;", "getSessionSelfMonitoringDataUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/selfmonitor/GetSessionSelfMonitoringDataUseCase;", "buildSelfMonitoringBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase;", "deleteSelfMonitoringDataUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/selfmonitor/DeleteSelfMonitoringDataUseCase;", "sendBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;", "sessionErrorHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/selfmonitor/GetSessionSelfMonitoringDataUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/selfmonitor/DeleteSelfMonitoringDataUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;)V", "buildBeacons", "data", "", "Lcom/dynatrace/android/sessionreplay/model/selfmonitoring/SelfMonitoringSerializedData;", "deleteSelfMonitoringData", "removeList", "getAllSelfMonitoringData", "visitId", "", "sendSelfMonitoringData", "Lcom/dynatrace/android/sessionreplay/core/usecases/selfmonitor/model/SelfMonitoringBeaconWithDataList;", "start", "params", "Params", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSyncSessionSelfMonitoringDataUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncSessionSelfMonitoringDataUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n*L\n1#1,84:1\n33#2,4:85\n*S KotlinDebug\n*F\n+ 1 SyncSessionSelfMonitoringDataUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase\n*L\n51#1:85,4\n*E\n"})
public final class SyncSessionSelfMonitoringDataUseCase
implements UseCase<Params, Result<Unit, BeaconResult>> {
    @NotNull
    private final GetSessionSelfMonitoringDataUseCase getSessionSelfMonitoringDataUseCase;
    @NotNull
    private final BuildSelfMonitoringBeaconUseCase buildSelfMonitoringBeaconUseCase;
    @NotNull
    private final DeleteSelfMonitoringDataUseCase deleteSelfMonitoringDataUseCase;
    @NotNull
    private final SendBeaconUseCase sendBeaconUseCase;
    @NotNull
    private final SessionErrorHandler sessionErrorHandler;

    public SyncSessionSelfMonitoringDataUseCase(@NotNull GetSessionSelfMonitoringDataUseCase getSessionSelfMonitoringDataUseCase, @NotNull BuildSelfMonitoringBeaconUseCase buildSelfMonitoringBeaconUseCase, @NotNull DeleteSelfMonitoringDataUseCase deleteSelfMonitoringDataUseCase, @NotNull SendBeaconUseCase sendBeaconUseCase, @NotNull SessionErrorHandler sessionErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)getSessionSelfMonitoringDataUseCase, (String)"getSessionSelfMonitoringDataUseCase");
        Intrinsics.checkNotNullParameter((Object)buildSelfMonitoringBeaconUseCase, (String)"buildSelfMonitoringBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteSelfMonitoringDataUseCase, (String)"deleteSelfMonitoringDataUseCase");
        Intrinsics.checkNotNullParameter((Object)sendBeaconUseCase, (String)"sendBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionErrorHandler, (String)"sessionErrorHandler");
        this.getSessionSelfMonitoringDataUseCase = getSessionSelfMonitoringDataUseCase;
        this.buildSelfMonitoringBeaconUseCase = buildSelfMonitoringBeaconUseCase;
        this.deleteSelfMonitoringDataUseCase = deleteSelfMonitoringDataUseCase;
        this.sendBeaconUseCase = sendBeaconUseCase;
        this.sessionErrorHandler = sessionErrorHandler;
    }

    @Override
    @NotNull
    public Result<Unit, BeaconResult> start(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (params.getSelfMonitoringFlags().isFSSelfMonitoringSendingEnabled()) {
            return this.getAllSelfMonitoringData(params.getVisitId());
        }
        return (Result)new Result.Success((Object)Unit.INSTANCE);
    }

    private final Result<Unit, BeaconResult> getAllSelfMonitoringData(String visitId) {
        Result<List<SelfMonitoringSerializedData>, DataError> result = this.getSessionSelfMonitoringDataUseCase.start(visitId);
        if (result instanceof Result.Error) {
            DTLogger.INSTANCE.error("Error getting SelfMonitoringData from Database: " + ((Result.Error)result).getError());
        } else if (result instanceof Result.Success && !((Collection)((Result.Success)result).getData()).isEmpty() && this.buildBeacons((List)((Result.Success)result).getData()) == BeaconResult.STOP_ERROR) {
            return (Result)new Result.Error((Object)BeaconResult.STOP_ERROR);
        }
        return (Result)new Result.Success((Object)Unit.INSTANCE);
    }

    private final BeaconResult buildBeacons(List<SelfMonitoringSerializedData> data) {
        Result<List<SelfMonitoringBeaconWithDataList>, BeaconSerializationError.BeaconSerialization> this_$iv = this.buildSelfMonitoringBeaconUseCase.start(new BuildSelfMonitoringBeaconUseCase.Params(data));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            List it = (List)((Result.Success)this_$iv).getData();
            boolean bl = false;
            return this.sendSelfMonitoringData(it);
        }
        return BeaconResult.SUCCESS;
    }

    private final BeaconResult sendSelfMonitoringData(List<SelfMonitoringBeaconWithDataList> data) {
        for (SelfMonitoringBeaconWithDataList selfMonitoring : data) {
            Result<String, APIError> result = this.sendBeaconUseCase.start(new SendBeaconUseCase.Params("", selfMonitoring.getBeacon(), false, 4, null));
            if (result instanceof Result.Error) {
                return this.sessionErrorHandler.handleBeaconError("Sending beacon for self-monitoring", (APIError)((Result.Error)result).getError());
            }
            if (!(result instanceof Result.Success)) continue;
            this.deleteSelfMonitoringData(selfMonitoring.getDataList());
        }
        return BeaconResult.SUCCESS;
    }

    private final void deleteSelfMonitoringData(List<SelfMonitoringSerializedData> removeList) {
        this.deleteSelfMonitoringDataUseCase.start(new DeleteSelfMonitoringDataUseCase.Params(removeList));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionSelfMonitoringDataUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "selfMonitoringFlags", "Lcom/dynatrace/android/sessionreplay/core/manager/model/SelfMonitoringFlags;", "(Ljava/lang/String;Lcom/dynatrace/android/sessionreplay/core/manager/model/SelfMonitoringFlags;)V", "getSelfMonitoringFlags", "()Lcom/dynatrace/android/sessionreplay/core/manager/model/SelfMonitoringFlags;", "getVisitId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        @NotNull
        private final SelfMonitoringFlags selfMonitoringFlags;

        public Params(@NotNull String visitId, @NotNull SelfMonitoringFlags selfMonitoringFlags) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)selfMonitoringFlags, (String)"selfMonitoringFlags");
            this.visitId = visitId;
            this.selfMonitoringFlags = selfMonitoringFlags;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final SelfMonitoringFlags getSelfMonitoringFlags() {
            return this.selfMonitoringFlags;
        }

        @NotNull
        public final String component1() {
            return this.visitId;
        }

        @NotNull
        public final SelfMonitoringFlags component2() {
            return this.selfMonitoringFlags;
        }

        @NotNull
        public final Params copy(@NotNull String visitId, @NotNull SelfMonitoringFlags selfMonitoringFlags) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)selfMonitoringFlags, (String)"selfMonitoringFlags");
            return new Params(visitId, selfMonitoringFlags);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, SelfMonitoringFlags selfMonitoringFlags, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.visitId;
            }
            if ((n & 2) != 0) {
                selfMonitoringFlags = params.selfMonitoringFlags;
            }
            return params.copy(string, selfMonitoringFlags);
        }

        @NotNull
        public String toString() {
            return "Params(visitId=" + this.visitId + ", selfMonitoringFlags=" + this.selfMonitoringFlags + ')';
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = result * 31 + this.selfMonitoringFlags.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.visitId, (Object)params.visitId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.selfMonitoringFlags, (Object)params.selfMonitoringFlags);
        }
    }
}

