/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sync;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.SessionErrorHandler;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.SendBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.model.BeaconResult;
import com.dynatrace.android.sessionreplay.core.usecases.datajob.DeleteDataJobUseCase;
import com.dynatrace.android.sessionreplay.model.APIError;
import com.dynatrace.android.sessionreplay.model.DataJob;
import com.dynatrace.android.sessionreplay.model.Result;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncDataJobUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncDataJobUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/model/BeaconResult;", "sendBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;", "deleteDataJobUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/datajob/DeleteDataJobUseCase;", "sessionErrorHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/datajob/DeleteDataJobUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;)V", "deleteDataJob", "", "id", "", "start", "params", "Params", "agent_release"})
public final class SyncDataJobUseCase
implements UseCase<Params, BeaconResult> {
    @NotNull
    private final SendBeaconUseCase sendBeaconUseCase;
    @NotNull
    private final DeleteDataJobUseCase deleteDataJobUseCase;
    @NotNull
    private final SessionErrorHandler sessionErrorHandler;

    public SyncDataJobUseCase(@NotNull SendBeaconUseCase sendBeaconUseCase, @NotNull DeleteDataJobUseCase deleteDataJobUseCase, @NotNull SessionErrorHandler sessionErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)sendBeaconUseCase, (String)"sendBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteDataJobUseCase, (String)"deleteDataJobUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionErrorHandler, (String)"sessionErrorHandler");
        this.sendBeaconUseCase = sendBeaconUseCase;
        this.deleteDataJobUseCase = deleteDataJobUseCase;
        this.sessionErrorHandler = sessionErrorHandler;
    }

    @Override
    @NotNull
    public BeaconResult start(@NotNull Params params) {
        BeaconResult beaconResult;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DataJob dataJob = params.getDataJob();
        DTLogger.INSTANCE.sync("Syncing data job for visit id: " + dataJob.getVisitId());
        Result<String, APIError> response = this.sendBeaconUseCase.start(new SendBeaconUseCase.Params(dataJob.getVisitId(), dataJob.getData(), false, 4, null));
        if (response instanceof Result.Success) {
            this.deleteDataJob(dataJob.getId());
            beaconResult = BeaconResult.SUCCESS;
        } else if (response instanceof Result.Error) {
            beaconResult = this.sessionErrorHandler.handleBeaconError("Sending data job with id " + dataJob.getId(), (APIError)((Result.Error)response).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return beaconResult;
    }

    private final void deleteDataJob(String id) {
        this.deleteDataJobUseCase.start(new DeleteDataJobUseCase.DeleteDataJobParams(id));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncDataJobUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "dataJob", "Lcom/dynatrace/android/sessionreplay/model/DataJob;", "(Lcom/dynatrace/android/sessionreplay/model/DataJob;)V", "getDataJob", "()Lcom/dynatrace/android/sessionreplay/model/DataJob;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final DataJob dataJob;

        public Params(@NotNull DataJob dataJob) {
            Intrinsics.checkNotNullParameter((Object)dataJob, (String)"dataJob");
            this.dataJob = dataJob;
        }

        @NotNull
        public final DataJob getDataJob() {
            return this.dataJob;
        }

        @NotNull
        public final DataJob component1() {
            return this.dataJob;
        }

        @NotNull
        public final Params copy(@NotNull DataJob dataJob) {
            Intrinsics.checkNotNullParameter((Object)dataJob, (String)"dataJob");
            return new Params(dataJob);
        }

        public static /* synthetic */ Params copy$default(Params params, DataJob dataJob, int n, Object object) {
            if ((n & 1) != 0) {
                dataJob = params.dataJob;
            }
            return params.copy(dataJob);
        }

        @NotNull
        public String toString() {
            return "Params(dataJob=" + this.dataJob + ')';
        }

        public int hashCode() {
            return this.dataJob.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            return Intrinsics.areEqual((Object)this.dataJob, (Object)params.dataJob);
        }
    }
}

