/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sync;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.manager.SessionErrorHandler;
import com.dynatrace.android.sessionreplay.core.usecases.UseCaseNoResult;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.BuildDataBeaconsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.beacon.SendBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.datajob.SaveDataJobUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.DeleteEventsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshotjob.StoreScreenshotJobUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.CheckSessionExpiredUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.CleanSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.SetSessionPartiallySentUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.UpdateSessionLastEventTimeUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sessionchunk.CreateSessionChunkUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SendReasonBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncCurrentSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SyncSessionScreenshotJobsUseCase;
import com.dynatrace.android.sessionreplay.model.APIError;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.DataJob;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.ScreenshotJob;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.android.sessionreplay.model.SessionChunk;
import com.dynatrace.android.sessionreplay.model.SessionState;
import com.dynatrace.protocols.mobile.sessionreplay.ReasonTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001Bu\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J \u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u001e\u00100\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u00104\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00105\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00106\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u00107\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u00108\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u00109\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010:\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0002H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncCurrentSessionUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCaseNoResult;", "", "getSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;", "updateSessionLastEventTimeUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/UpdateSessionLastEventTimeUseCase;", "checkSessionExpiredUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/CheckSessionExpiredUseCase;", "setSessionPartiallySentUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/SetSessionPartiallySentUseCase;", "buildDataBeaconsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildDataBeaconsUseCase;", "createSessionChunkUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase;", "sendBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;", "deleteEventsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/DeleteEventsUseCase;", "storeScreenshotJobUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/StoreScreenshotJobUseCase;", "saveDataJobUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/datajob/SaveDataJobUseCase;", "syncSessionScreenshotJobsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase;", "sessionErrorHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;", "cleanSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;", "sendReasonBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/UpdateSessionLastEventTimeUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/CheckSessionExpiredUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/SetSessionPartiallySentUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildDataBeaconsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/event/DeleteEventsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshotjob/StoreScreenshotJobUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/datajob/SaveDataJobUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SyncSessionScreenshotJobsUseCase;Lcom/dynatrace/android/sessionreplay/core/manager/SessionErrorHandler;Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;)V", "checkExpired", "", "session", "Lcom/dynatrace/android/sessionreplay/model/Session;", "onNotExpired", "Lkotlin/Function0;", "createScreenshotJob", "visitId", "visitorId", "screenshot", "Lcom/dynatrace/android/sessionreplay/model/SessionChunk$ScreenshotInfo;", "finishSyncSession", "sessionChunk", "Lcom/dynatrace/android/sessionreplay/model/SessionChunk;", "syncScreenshotJobs", "", "handleDataBeacons", "dataBeaconList", "", "", "handleSessionScreenshots", "onGetSession", "onNotExpiredSession", "onSendBeaconSuccess", "onSendDataBeaconError", "sendDataBeaconsFromSession", "start", "agent_release"})
@SourceDebugExtension(value={"SMAP\nSyncCurrentSessionUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncCurrentSessionUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncCurrentSessionUseCase\n+ 2 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n33#2,4:206\n40#2,4:210\n33#2,4:214\n40#2,4:218\n33#2,4:222\n40#2,4:226\n33#2,4:230\n40#2,4:234\n40#2,4:241\n40#2,4:246\n1855#3,2:238\n1855#3:240\n1856#3:245\n*S KotlinDebug\n*F\n+ 1 SyncCurrentSessionUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sync/SyncCurrentSessionUseCase\n*L\n44#1:206,4\n51#1:210,4\n89#1:214,4\n95#1:218,4\n109#1:222,4\n111#1:226,4\n143#1:230,4\n145#1:234,4\n187#1:241,4\n200#1:246,4\n170#1:238,2\n182#1:240\n182#1:245\n*E\n"})
public final class SyncCurrentSessionUseCase
implements UseCaseNoResult<String> {
    @NotNull
    private final GetSessionUseCase getSessionUseCase;
    @NotNull
    private final UpdateSessionLastEventTimeUseCase updateSessionLastEventTimeUseCase;
    @NotNull
    private final CheckSessionExpiredUseCase checkSessionExpiredUseCase;
    @NotNull
    private final SetSessionPartiallySentUseCase setSessionPartiallySentUseCase;
    @NotNull
    private final BuildDataBeaconsUseCase buildDataBeaconsUseCase;
    @NotNull
    private final CreateSessionChunkUseCase createSessionChunkUseCase;
    @NotNull
    private final SendBeaconUseCase sendBeaconUseCase;
    @NotNull
    private final DeleteEventsUseCase deleteEventsUseCase;
    @NotNull
    private final StoreScreenshotJobUseCase storeScreenshotJobUseCase;
    @NotNull
    private final SaveDataJobUseCase saveDataJobUseCase;
    @NotNull
    private final SyncSessionScreenshotJobsUseCase syncSessionScreenshotJobsUseCase;
    @NotNull
    private final SessionErrorHandler sessionErrorHandler;
    @NotNull
    private final CleanSessionUseCase cleanSessionUseCase;
    @NotNull
    private final SendReasonBeaconUseCase sendReasonBeaconUseCase;

    public SyncCurrentSessionUseCase(@NotNull GetSessionUseCase getSessionUseCase, @NotNull UpdateSessionLastEventTimeUseCase updateSessionLastEventTimeUseCase, @NotNull CheckSessionExpiredUseCase checkSessionExpiredUseCase, @NotNull SetSessionPartiallySentUseCase setSessionPartiallySentUseCase, @NotNull BuildDataBeaconsUseCase buildDataBeaconsUseCase, @NotNull CreateSessionChunkUseCase createSessionChunkUseCase, @NotNull SendBeaconUseCase sendBeaconUseCase, @NotNull DeleteEventsUseCase deleteEventsUseCase, @NotNull StoreScreenshotJobUseCase storeScreenshotJobUseCase, @NotNull SaveDataJobUseCase saveDataJobUseCase, @NotNull SyncSessionScreenshotJobsUseCase syncSessionScreenshotJobsUseCase, @NotNull SessionErrorHandler sessionErrorHandler, @NotNull CleanSessionUseCase cleanSessionUseCase, @NotNull SendReasonBeaconUseCase sendReasonBeaconUseCase) {
        Intrinsics.checkNotNullParameter((Object)getSessionUseCase, (String)"getSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)updateSessionLastEventTimeUseCase, (String)"updateSessionLastEventTimeUseCase");
        Intrinsics.checkNotNullParameter((Object)checkSessionExpiredUseCase, (String)"checkSessionExpiredUseCase");
        Intrinsics.checkNotNullParameter((Object)setSessionPartiallySentUseCase, (String)"setSessionPartiallySentUseCase");
        Intrinsics.checkNotNullParameter((Object)buildDataBeaconsUseCase, (String)"buildDataBeaconsUseCase");
        Intrinsics.checkNotNullParameter((Object)createSessionChunkUseCase, (String)"createSessionChunkUseCase");
        Intrinsics.checkNotNullParameter((Object)sendBeaconUseCase, (String)"sendBeaconUseCase");
        Intrinsics.checkNotNullParameter((Object)deleteEventsUseCase, (String)"deleteEventsUseCase");
        Intrinsics.checkNotNullParameter((Object)storeScreenshotJobUseCase, (String)"storeScreenshotJobUseCase");
        Intrinsics.checkNotNullParameter((Object)saveDataJobUseCase, (String)"saveDataJobUseCase");
        Intrinsics.checkNotNullParameter((Object)syncSessionScreenshotJobsUseCase, (String)"syncSessionScreenshotJobsUseCase");
        Intrinsics.checkNotNullParameter((Object)sessionErrorHandler, (String)"sessionErrorHandler");
        Intrinsics.checkNotNullParameter((Object)cleanSessionUseCase, (String)"cleanSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)sendReasonBeaconUseCase, (String)"sendReasonBeaconUseCase");
        this.getSessionUseCase = getSessionUseCase;
        this.updateSessionLastEventTimeUseCase = updateSessionLastEventTimeUseCase;
        this.checkSessionExpiredUseCase = checkSessionExpiredUseCase;
        this.setSessionPartiallySentUseCase = setSessionPartiallySentUseCase;
        this.buildDataBeaconsUseCase = buildDataBeaconsUseCase;
        this.createSessionChunkUseCase = createSessionChunkUseCase;
        this.sendBeaconUseCase = sendBeaconUseCase;
        this.deleteEventsUseCase = deleteEventsUseCase;
        this.storeScreenshotJobUseCase = storeScreenshotJobUseCase;
        this.saveDataJobUseCase = saveDataJobUseCase;
        this.syncSessionScreenshotJobsUseCase = syncSessionScreenshotJobsUseCase;
        this.sessionErrorHandler = sessionErrorHandler;
        this.cleanSessionUseCase = cleanSessionUseCase;
        this.sendReasonBeaconUseCase = sendReasonBeaconUseCase;
    }

    @Override
    public void start(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        Result<Session, DataError> this_$iv = this.getSessionUseCase.start(visitId);
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            Session session = (Session)((Result.Success)this_$iv).getData();
            boolean bl = false;
            if (session.getSessionState() != SessionState.FULL) {
                DTLogger.INSTANCE.info("Current session is not full, ignoring current sync");
                return;
            }
            this.onGetSession(session);
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            DataError error = (DataError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error getting current session " + visitId + ": " + error);
        }
    }

    private final void onGetSession(Session session) {
        block2: {
            Unit unit;
            SessionChunk sessionChunk;
            SessionChunk sessionChunk2 = sessionChunk = this.createSessionChunkUseCase.start(session);
            if (sessionChunk2 != null) {
                SessionChunk chunk = sessionChunk2;
                boolean bl = false;
                this.updateSessionLastEventTimeUseCase.start(new UpdateSessionLastEventTimeUseCase.Params(chunk.getVisitId(), chunk.getEndTime()));
                Session updatedSession = Session.copy$default((Session)session, null, null, (int)0, (int)0, (boolean)false, (boolean)false, (Long)chunk.getEndTime(), null, (int)191, null);
                this.checkExpired(updatedSession, (Function0<Unit>)((Function0)new Function0<Unit>(this, chunk){
                    final /* synthetic */ SyncCurrentSessionUseCase this$0;
                    final /* synthetic */ SessionChunk $chunk;
                    {
                        this.this$0 = $receiver;
                        this.$chunk = $chunk;
                        super(0);
                    }

                    public final void invoke() {
                        SyncCurrentSessionUseCase.access$onNotExpiredSession(this.this$0, this.$chunk);
                    }
                }));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            SyncCurrentSessionUseCase.checkExpired$default(this, session, null, 2, null);
        }
    }

    private final void checkExpired(Session session, Function0<Unit> onNotExpired) {
        Boolean isExpired = this.checkSessionExpiredUseCase.start(session);
        if (Intrinsics.areEqual((Object)isExpired, (Object)true)) {
            this.sendReasonBeaconUseCase.start(new SendReasonBeaconUseCase.Params(session.getVisitId(), ReasonTag.REASON_RETENTION_TIME));
            this.cleanSessionUseCase.start(session.getVisitId());
        } else {
            onNotExpired.invoke();
        }
    }

    static /* synthetic */ void checkExpired$default(SyncCurrentSessionUseCase syncCurrentSessionUseCase, Session session, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkExpired.1.INSTANCE;
        }
        syncCurrentSessionUseCase.checkExpired(session, (Function0<Unit>)function0);
    }

    private final void onNotExpiredSession(SessionChunk sessionChunk) {
        Result<List<byte[]>, BeaconSerializationError.BeaconSerialization> this_$iv = this.buildDataBeaconsUseCase.start(new BuildDataBeaconsUseCase.Params(sessionChunk));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            List serializedDataBeacons = (List)((Result.Success)this_$iv).getData();
            boolean bl = false;
            if (!((Collection)serializedDataBeacons).isEmpty()) {
                this.sendDataBeaconsFromSession(serializedDataBeacons, sessionChunk);
            } else {
                DTLogger.INSTANCE.info("Serialized beacons are empty for sessionChunk " + sessionChunk.getVisitId());
            }
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            BeaconSerializationError.BeaconSerialization error = (BeaconSerializationError.BeaconSerialization)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error building beacon for sessionChunk " + sessionChunk.getVisitId() + ": " + error);
        }
    }

    private final void sendDataBeaconsFromSession(List<byte[]> dataBeaconList, SessionChunk sessionChunk) {
        String it;
        Result<String, APIError> this_$iv = this.sendBeaconUseCase.start(new SendBeaconUseCase.Params(sessionChunk.getVisitId(), (byte[])CollectionsKt.first(dataBeaconList), false, 4, null));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            it = (String)((Result.Success)this_$iv).getData();
            boolean bl = false;
            this.onSendBeaconSuccess(dataBeaconList, sessionChunk);
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            it = (APIError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            this.sessionErrorHandler.handleBeaconError("Sending data beacon from session with visitId " + sessionChunk.getVisitId(), (APIError)it);
        }
    }

    private final void onSendBeaconSuccess(List<byte[]> dataBeaconList, SessionChunk sessionChunk) {
        this.setSessionPartiallySentUseCase.start(sessionChunk.getVisitId());
        if (dataBeaconList.size() > 1) {
            List $this$onSendBeaconSuccess_u24lambda_u247 = CollectionsKt.toMutableList((Collection)dataBeaconList);
            boolean bl = false;
            $this$onSendBeaconSuccess_u24lambda_u247.remove(CollectionsKt.first(dataBeaconList));
            this.handleDataBeacons($this$onSendBeaconSuccess_u24lambda_u247, sessionChunk);
        } else {
            this.finishSyncSession(sessionChunk, true);
        }
    }

    private final void handleDataBeacons(List<byte[]> dataBeaconList, SessionChunk sessionChunk) {
        String it;
        Result<String, APIError> this_$iv = this.sendBeaconUseCase.start(new SendBeaconUseCase.Params(sessionChunk.getVisitId(), (byte[])CollectionsKt.first(dataBeaconList), false, 4, null));
        boolean $i$f$onSuccess = false;
        if (this_$iv instanceof Result.Success) {
            it = (String)((Result.Success)this_$iv).getData();
            boolean bl = false;
            this.onSendBeaconSuccess(dataBeaconList, sessionChunk);
        }
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            it = (APIError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            this.finishSyncSession(sessionChunk, false);
            this.sessionErrorHandler.handleBeaconError("Sending data beacon from session with visitId " + sessionChunk.getVisitId(), (APIError)it);
            this.onSendDataBeaconError(dataBeaconList, sessionChunk);
        }
    }

    private final void finishSyncSession(SessionChunk sessionChunk, boolean syncScreenshotJobs) {
        this.handleSessionScreenshots(sessionChunk, syncScreenshotJobs);
        this.deleteEventsUseCase.start(new ArrayList<Event>(sessionChunk.getEvents()));
    }

    private final void handleSessionScreenshots(SessionChunk sessionChunk, boolean syncScreenshotJobs) {
        Iterable $this$forEach$iv = sessionChunk.getScreenshots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SessionChunk.ScreenshotInfo it = (SessionChunk.ScreenshotInfo)element$iv;
            boolean bl = false;
            this.createScreenshotJob(sessionChunk.getVisitId(), sessionChunk.getVisitorId(), it);
        }
        if (syncScreenshotJobs) {
            this.syncSessionScreenshotJobsUseCase.start(sessionChunk.getVisitId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onSendDataBeaconError(List<byte[]> dataBeaconList, SessionChunk sessionChunk) {
        Iterable $this$forEach$iv = dataBeaconList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            byte[] beacon = (byte[])element$iv;
            boolean bl = false;
            Result<DataJob, DataError> result = this.saveDataJobUseCase.start(new SaveDataJobUseCase.SaveDataJobParams(new DataJob(1, beacon, sessionChunk.getVisitId(), null, 8, null)));
            boolean $i$f$onError = false;
            if (!(this_$iv instanceof Result.Error)) continue;
            DataError error = (DataError)((Result.Error)this_$iv).getError();
            boolean bl2 = false;
            DTLogger.INSTANCE.error("Error saving data job for beacon " + sessionChunk.getVisitId() + ": " + error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createScreenshotJob(String visitId, String visitorId, SessionChunk.ScreenshotInfo screenshot) {
        void this_$iv;
        Result<ScreenshotJob, DataError> result = this.storeScreenshotJobUseCase.start(new ScreenshotJob(visitId, visitorId, screenshot.getMd5(), screenshot.getTimestamp(), null, 16, null));
        boolean $i$f$onError = false;
        if (this_$iv instanceof Result.Error) {
            DataError error = (DataError)((Result.Error)this_$iv).getError();
            boolean bl = false;
            DTLogger.INSTANCE.error("Error storing screenshot job for screenshot " + screenshot + ".md5: " + error);
        }
    }

    public static final /* synthetic */ void access$onNotExpiredSession(SyncCurrentSessionUseCase $this, SessionChunk sessionChunk) {
        $this.onNotExpiredSession(sessionChunk);
    }
}

