/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.sessionchunk;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.configuration.TenantConfiguration;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.event.GetAllEventsByVisitIdUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.GetLogsByVisitIdUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.serialization.SerializeDeviceInfoUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.serialization.SerializeEventUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.serialization.SerializeLogUseCase;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Durable;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Log;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.SerializationError;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.android.sessionreplay.model.SessionChunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u001e\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/model/Session;", "Lcom/dynatrace/android/sessionreplay/model/SessionChunk;", "getEventsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;", "serializeEventUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/serialization/SerializeEventUseCase;", "serializeLogUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/serialization/SerializeLogUseCase;", "getLogsByVisitIdUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/log/GetLogsByVisitIdUseCase;", "serializeDeviceInfoUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/serialization/SerializeDeviceInfoUseCase;", "tenantConfiguration", "Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/event/GetAllEventsByVisitIdUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/serialization/SerializeEventUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/serialization/SerializeLogUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/log/GetLogsByVisitIdUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/serialization/SerializeDeviceInfoUseCase;Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;)V", "createSessionChunk", "session", "events", "", "Lcom/dynatrace/android/sessionreplay/model/Event;", "getJsonFromMap", "Lorg/json/JSONObject;", "map", "", "", "", "getLogs", "Lcom/dynatrace/android/sessionreplay/model/Log;", "visitId", "serializeLogs", "Lorg/json/JSONArray;", "logs", "start", "whichSerialVersionShouldUse", "", "agent_release"})
@SourceDebugExtension(value={"SMAP\nCreateSessionChunkUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateSessionChunkUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Result.kt\ncom/dynatrace/android/sessionreplay/model/Result\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1855#2:133\n2624#2,3:138\n1856#2:141\n1549#2:143\n1620#2,3:144\n33#3,4:134\n1#4:142\n*S KotlinDebug\n*F\n+ 1 CreateSessionChunkUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/sessionchunk/CreateSessionChunkUseCase\n*L\n53#1:133\n60#1:138,3\n53#1:141\n110#1:143\n110#1:144,3\n57#1:134,4\n*E\n"})
public final class CreateSessionChunkUseCase
implements UseCase<Session, SessionChunk> {
    @NotNull
    private final GetAllEventsByVisitIdUseCase getEventsUseCase;
    @NotNull
    private final SerializeEventUseCase serializeEventUseCase;
    @NotNull
    private final SerializeLogUseCase serializeLogUseCase;
    @NotNull
    private final GetLogsByVisitIdUseCase getLogsByVisitIdUseCase;
    @NotNull
    private final SerializeDeviceInfoUseCase serializeDeviceInfoUseCase;
    @NotNull
    private final TenantConfiguration tenantConfiguration;

    public CreateSessionChunkUseCase(@NotNull GetAllEventsByVisitIdUseCase getEventsUseCase, @NotNull SerializeEventUseCase serializeEventUseCase, @NotNull SerializeLogUseCase serializeLogUseCase, @NotNull GetLogsByVisitIdUseCase getLogsByVisitIdUseCase, @NotNull SerializeDeviceInfoUseCase serializeDeviceInfoUseCase, @NotNull TenantConfiguration tenantConfiguration) {
        Intrinsics.checkNotNullParameter((Object)getEventsUseCase, (String)"getEventsUseCase");
        Intrinsics.checkNotNullParameter((Object)serializeEventUseCase, (String)"serializeEventUseCase");
        Intrinsics.checkNotNullParameter((Object)serializeLogUseCase, (String)"serializeLogUseCase");
        Intrinsics.checkNotNullParameter((Object)getLogsByVisitIdUseCase, (String)"getLogsByVisitIdUseCase");
        Intrinsics.checkNotNullParameter((Object)serializeDeviceInfoUseCase, (String)"serializeDeviceInfoUseCase");
        Intrinsics.checkNotNullParameter((Object)tenantConfiguration, (String)"tenantConfiguration");
        this.getEventsUseCase = getEventsUseCase;
        this.serializeEventUseCase = serializeEventUseCase;
        this.serializeLogUseCase = serializeLogUseCase;
        this.getLogsByVisitIdUseCase = getLogsByVisitIdUseCase;
        this.serializeDeviceInfoUseCase = serializeDeviceInfoUseCase;
        this.tenantConfiguration = tenantConfiguration;
    }

    @Override
    @Nullable
    public SessionChunk start(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List<Event> events = this.getEventsUseCase.start(session.getVisitId());
        if (events.isEmpty()) {
            DTLogger.INSTANCE.info("Session chunk not created due to lack of events");
            return null;
        }
        return this.createSessionChunk(session, CollectionsKt.toSet((Iterable)events));
    }

    private final SessionChunk createSessionChunk(Session session, Set<? extends Event> events) {
        long startTime = 0L;
        startTime = Long.MAX_VALUE;
        long endTime = 0L;
        endTime = Long.MIN_VALUE;
        JSONObject sessionJson = new JSONObject();
        JSONArray windowArray = new JSONArray();
        sessionJson.put("windows", (Object)windowArray);
        JSONObject windowJson = new JSONObject();
        JSONArray viewsArray = new JSONArray();
        HashSet<SessionChunk.ScreenshotInfo> processedScreenshots = new HashSet<SessionChunk.ScreenshotInfo>();
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String screenshotId;
            Event event;
            block5: {
                event = (Event)element$iv;
                boolean bl2 = false;
                startTime = Math.min(startTime, event.getStartTime().getTime());
                endTime = Math.max(endTime, event instanceof Durable ? ((Durable)event).getEndTime().getTime() : event.getStartTime().getTime());
                Result<JSONObject, SerializationError> this_$iv = this.serializeEventUseCase.start(event);
                boolean $i$f$onSuccess = false;
                if (this_$iv instanceof Result.Success) {
                    Object p0 = ((Result.Success)this_$iv).getData();
                    boolean bl3 = false;
                    viewsArray.put(p0);
                }
                if ((screenshotId = event.getScreenshotId()) == null) continue;
                Iterable $this$none$iv = processedScreenshots;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        SessionChunk.ScreenshotInfo it = (SessionChunk.ScreenshotInfo)element$iv2;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getMd5(), (Object)screenshotId)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            processedScreenshots.add(new SessionChunk.ScreenshotInfo(screenshotId, event.getStartTime()));
        }
        windowJson.put("views", (Object)viewsArray);
        windowArray.put((Object)windowJson);
        Set<Log> logs = this.getLogs(session.getVisitId());
        JSONObject debugJson = new JSONObject().put("logs", (Object)this.serializeLogs(logs, session.getVisitId()));
        Map<String, Object> deviceInfo = this.serializeDeviceInfoUseCase.start(new SerializeDeviceInfoUseCase.Params(session));
        sessionJson.put("debug", (Object)debugJson);
        sessionJson.put("metadata", (Object)this.getJsonFromMap(deviceInfo));
        DTLogger.INSTANCE.info("Creating session chunk metadata for visitId " + session.getVisitId() + ": " + sessionJson);
        return new SessionChunk(session.getVisitorId(), session.getVisitId(), events, (Set)processedScreenshots, logs, sessionJson, startTime, endTime, this.whichSerialVersionShouldUse());
    }

    private final Set<Log> getLogs(String visitId) {
        Set set;
        block3: {
            block4: {
                block6: {
                    Object object;
                    block5: {
                        Result<List<Log>, DataError> result;
                        block2: {
                            result = this.getLogsByVisitIdUseCase.start(new GetLogsByVisitIdUseCase.Params(visitId));
                            if (!(result instanceof Result.Success)) break block2;
                            set = CollectionsKt.toSet((Iterable)((Iterable)((Result.Success)result).getData()));
                            break block3;
                        }
                        if (!(result instanceof Result.Error)) break block4;
                        object = (JSONObject)this.serializeLogUseCase.start(new SerializeLogUseCase.Params(new Log(visitId, "Error retrieving logs: " + ((Result.Error)result).getError(), 0L, null, 12, null))).getOrNull();
                        if (object == null) break block5;
                        JSONObject it = object;
                        boolean bl = false;
                        List list = CollectionsKt.listOf((Object)it);
                        object = list;
                        if (list != null) break block6;
                    }
                    object = CollectionsKt.emptyList();
                }
                set = SetsKt.emptySet();
                break block3;
            }
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final int whichSerialVersionShouldUse() {
        return Math.min(1, this.tenantConfiguration.getDataProtocolVersion());
    }

    /*
     * WARNING - void declaration
     */
    private final JSONArray serializeLogs(Set<Log> logs, String visitId) {
        JSONArray jSONArray;
        if (!((Collection)logs).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = logs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Log log = (Log)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((JSONObject)this.serializeLogUseCase.start(new SerializeLogUseCase.Params((Log)it)).getOrNull());
            }
            Collection collection = (List)destination$iv$iv;
            jSONArray = new JSONArray(collection);
        } else {
            new Log(visitId, "There are no logs for this session", 0L, null, 12, null);
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    private final JSONObject getJsonFromMap(Map<String, ? extends Object> map) {
        JSONObject jsonData = new JSONObject();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                value = this.getJsonFromMap((Map)value);
            }
            jsonData.put(key, value);
        }
        return jsonData;
    }
}

