/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.session;

import com.dynatrace.android.sessionreplay.core.usecases.UseCaseNoResult;
import com.dynatrace.android.sessionreplay.core.usecases.session.CheckSessionExpiredUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.CleanSessionUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.session.GetAllSessionsUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.sync.SendReasonBeaconUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.syncjob.CheckSessionEmptyUseCase;
import com.dynatrace.android.sessionreplay.model.Session;
import com.dynatrace.protocols.mobile.sessionreplay.ReasonTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/session/RemoveInvalidSessionsUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCaseNoResult;", "", "getAllSessionsUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetAllSessionsUseCase;", "cleanSessionUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;", "checkSessionExpiredUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/session/CheckSessionExpiredUseCase;", "checkSessionEmptyUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/syncjob/CheckSessionEmptyUseCase;", "sendReasonBeaconUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/session/GetAllSessionsUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/CleanSessionUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/session/CheckSessionExpiredUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/syncjob/CheckSessionEmptyUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/sync/SendReasonBeaconUseCase;)V", "isNonCurrentSessionStateInvalid", "", "session", "Lcom/dynatrace/android/sessionreplay/model/Session;", "start", "", "currentSessionVisitId", "agent_release"})
@SourceDebugExtension(value={"SMAP\nRemoveInvalidSessionsUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveInvalidSessionsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/session/RemoveInvalidSessionsUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1855#2,2:48\n*S KotlinDebug\n*F\n+ 1 RemoveInvalidSessionsUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/session/RemoveInvalidSessionsUseCase\n*L\n19#1:48,2\n*E\n"})
public final class RemoveInvalidSessionsUseCase
implements UseCaseNoResult<String> {
    @NotNull
    private final GetAllSessionsUseCase getAllSessionsUseCase;
    @NotNull
    private final CleanSessionUseCase cleanSessionUseCase;
    @NotNull
    private final CheckSessionExpiredUseCase checkSessionExpiredUseCase;
    @NotNull
    private final CheckSessionEmptyUseCase checkSessionEmptyUseCase;
    @NotNull
    private final SendReasonBeaconUseCase sendReasonBeaconUseCase;

    public RemoveInvalidSessionsUseCase(@NotNull GetAllSessionsUseCase getAllSessionsUseCase, @NotNull CleanSessionUseCase cleanSessionUseCase, @NotNull CheckSessionExpiredUseCase checkSessionExpiredUseCase, @NotNull CheckSessionEmptyUseCase checkSessionEmptyUseCase, @NotNull SendReasonBeaconUseCase sendReasonBeaconUseCase) {
        Intrinsics.checkNotNullParameter((Object)getAllSessionsUseCase, (String)"getAllSessionsUseCase");
        Intrinsics.checkNotNullParameter((Object)cleanSessionUseCase, (String)"cleanSessionUseCase");
        Intrinsics.checkNotNullParameter((Object)checkSessionExpiredUseCase, (String)"checkSessionExpiredUseCase");
        Intrinsics.checkNotNullParameter((Object)checkSessionEmptyUseCase, (String)"checkSessionEmptyUseCase");
        Intrinsics.checkNotNullParameter((Object)sendReasonBeaconUseCase, (String)"sendReasonBeaconUseCase");
        this.getAllSessionsUseCase = getAllSessionsUseCase;
        this.cleanSessionUseCase = cleanSessionUseCase;
        this.checkSessionExpiredUseCase = checkSessionExpiredUseCase;
        this.checkSessionEmptyUseCase = checkSessionEmptyUseCase;
        this.sendReasonBeaconUseCase = sendReasonBeaconUseCase;
    }

    @Override
    public void start(@Nullable String currentSessionVisitId) {
        Object sessions = this.getAllSessionsUseCase.start();
        Iterable $this$forEach$iv = (Iterable)sessions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session session = (Session)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)session.getVisitId(), (Object)currentSessionVisitId)) {
                return;
            }
            Boolean isSessionExpired = this.checkSessionExpiredUseCase.start(session);
            boolean isSessionStateInvalid = this.isNonCurrentSessionStateInvalid(session);
            if (Intrinsics.areEqual((Object)isSessionExpired, (Object)true)) {
                this.sendReasonBeaconUseCase.start(new SendReasonBeaconUseCase.Params(session.getVisitId(), ReasonTag.REASON_RETENTION_TIME));
            }
            if (!Intrinsics.areEqual((Object)isSessionExpired, (Object)true) && !isSessionStateInvalid) continue;
            this.cleanSessionUseCase.start(session.getVisitId());
        }
    }

    private final boolean isNonCurrentSessionStateInvalid(Session session) {
        Session $this$isNonCurrentSessionStateInvalid_u24lambda_u241 = session;
        boolean bl = false;
        boolean crashStateSessionNotCrashed = ($this$isNonCurrentSessionStateInvalid_u24lambda_u241.isCrash() || $this$isNonCurrentSessionStateInvalid_u24lambda_u241.isTrimCrash()) && !session.getDidCrash();
        boolean isSessionEmpty = this.checkSessionEmptyUseCase.start(session.getVisitId());
        return $this$isNonCurrentSessionStateInvalid_u24lambda_u241.isRecording() || crashStateSessionNotCrashed || isSessionEmpty;
    }
}

