/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.session;

import com.dynatrace.android.sessionreplay.core.configuration.AppConfiguration;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.utils.TimeHelper;
import com.dynatrace.android.sessionreplay.model.Session;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/session/CheckSessionExpiredUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/model/Session;", "", "timeHelper", "Lcom/dynatrace/android/sessionreplay/core/utils/TimeHelper;", "appConfig", "Lcom/dynatrace/android/sessionreplay/core/configuration/AppConfiguration;", "(Lcom/dynatrace/android/sessionreplay/core/utils/TimeHelper;Lcom/dynatrace/android/sessionreplay/core/configuration/AppConfiguration;)V", "isBeyond", "from", "", "diff", "start", "session", "(Lcom/dynatrace/android/sessionreplay/model/Session;)Ljava/lang/Boolean;", "isExpired", "agent_release"})
public final class CheckSessionExpiredUseCase
implements UseCase<Session, Boolean> {
    @NotNull
    private final TimeHelper timeHelper;
    @NotNull
    private final AppConfiguration appConfig;

    public CheckSessionExpiredUseCase(@NotNull TimeHelper timeHelper, @NotNull AppConfiguration appConfig) {
        Intrinsics.checkNotNullParameter((Object)timeHelper, (String)"timeHelper");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.timeHelper = timeHelper;
        this.appConfig = appConfig;
    }

    @Override
    @Nullable
    public Boolean start(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.isExpired(session);
    }

    private final Boolean isExpired(Session $this$isExpired) {
        Boolean bl;
        Long l = $this$isExpired.getLastEventTimestamp();
        if (l != null) {
            long lastTimestamp = ((Number)l).longValue();
            boolean bl2 = false;
            bl = !$this$isExpired.isPartiallySent() && this.isBeyond(lastTimestamp, this.appConfig.getShortRetentionTime--CYLg48()) || $this$isExpired.isPartiallySent() && this.isBeyond(lastTimestamp, this.appConfig.getLongRetentionTime--CYLg48());
        } else {
            bl = null;
        }
        return bl;
    }

    private final boolean isBeyond(long from, long diff) {
        return this.timeHelper.isPast(from + diff);
    }
}

