/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.screenshot;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.SaveLogUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.FreeUpSpaceUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.SaveScreenshotUseCase;
import com.dynatrace.android.sessionreplay.core.utils.ExtensionsKt;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfo;
import com.dynatrace.android.sessionreplay.model.FileError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.StoreScreenshotError;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/StoreScreenshotUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/StoreScreenshotUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "Lcom/dynatrace/android/sessionreplay/model/StoreScreenshotError;", "saveScreenshotUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase;", "freeUpSpaceUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase;", "saveLogUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;", "(Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/FreeUpSpaceUseCase;Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;)V", "freeUpSpaceAndRetry", "params", "fileSize", "", "saveScreenshot", "visitId", "", "screenshotInfo", "image", "", "start", "Params", "agent_release"})
public final class StoreScreenshotUseCase
implements UseCase<Params, Result<ScreenshotInfo, StoreScreenshotError>> {
    @NotNull
    private final SaveScreenshotUseCase saveScreenshotUseCase;
    @NotNull
    private final FreeUpSpaceUseCase freeUpSpaceUseCase;
    @NotNull
    private final SaveLogUseCase saveLogUseCase;

    public StoreScreenshotUseCase(@NotNull SaveScreenshotUseCase saveScreenshotUseCase, @NotNull FreeUpSpaceUseCase freeUpSpaceUseCase, @NotNull SaveLogUseCase saveLogUseCase) {
        Intrinsics.checkNotNullParameter((Object)saveScreenshotUseCase, (String)"saveScreenshotUseCase");
        Intrinsics.checkNotNullParameter((Object)freeUpSpaceUseCase, (String)"freeUpSpaceUseCase");
        Intrinsics.checkNotNullParameter((Object)saveLogUseCase, (String)"saveLogUseCase");
        this.saveScreenshotUseCase = saveScreenshotUseCase;
        this.freeUpSpaceUseCase = freeUpSpaceUseCase;
        this.saveLogUseCase = saveLogUseCase;
    }

    @Override
    @NotNull
    public Result<ScreenshotInfo, StoreScreenshotError> start(@NotNull Params params) {
        Result<ScreenshotInfo, StoreScreenshotError> result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result<ScreenshotInfo, StoreScreenshotError> result2 = this.saveScreenshot(params.getVisitId(), params.getScreenshotInfo(), params.getImage());
        if (result2 instanceof Result.Success) {
            result = result2;
        } else if (result2 instanceof Result.Error) {
            if (((Result.Error)result2).getError() instanceof StoreScreenshotError.SaveLimitReached) {
                Object object = ((Result.Error)result2).getError();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.dynatrace.android.sessionreplay.model.StoreScreenshotError.SaveLimitReached");
                StoreScreenshotError.SaveLimitReached error = (StoreScreenshotError.SaveLimitReached)object;
                result = this.freeUpSpaceAndRetry(params, error.getFileSize());
            } else {
                result = result2;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final Result<ScreenshotInfo, StoreScreenshotError> saveScreenshot(String visitId, ScreenshotInfo screenshotInfo, byte[] image) {
        Result<ScreenshotInfo, FileError> result = this.saveScreenshotUseCase.start(new SaveScreenshotUseCase.Params(screenshotInfo, image));
        if (!(result instanceof Result.Success)) {
            if (result instanceof Result.Error) {
                FileError error = (FileError)((Result.Error)result).getError();
                ExtensionsKt.logError(this.saveLogUseCase, visitId, "Error saving screenshot to storage: " + error);
                FileError fileError = error;
                return fileError instanceof FileError.StorageLimitReached ? (Result)new Result.Error((Object)new StoreScreenshotError.SaveLimitReached(((FileError.StorageLimitReached)error).getFileSize())) : (fileError instanceof FileError.IOError ? (Result)new Result.Error((Object)new StoreScreenshotError.SaveError(((FileError.IOError)error).getThrowable())) : (Result)new Result.Error((Object)new StoreScreenshotError.SaveError(null, 1, null)));
            }
            throw new NoWhenBranchMatchedException();
        }
        return (Result)new Result.Success(((Result.Success)result).getData());
    }

    private final Result<ScreenshotInfo, StoreScreenshotError> freeUpSpaceAndRetry(Params params, long fileSize) {
        Result result;
        if (this.freeUpSpaceUseCase.start(new FreeUpSpaceUseCase.Params(params.getVisitId(), fileSize)).booleanValue()) {
            result = this.saveScreenshot(params.getVisitId(), params.getScreenshotInfo(), params.getImage());
        } else {
            ExtensionsKt.logError(this.saveLogUseCase, params.getVisitId(), "Cannot free enough space");
            result = (Result)new Result.Error((Object)new StoreScreenshotError.NotEnoughSpaceAfterFreeUp(fileSize));
        }
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/StoreScreenshotUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "screenshotInfo", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "image", "", "(Ljava/lang/String;Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;[B)V", "getImage", "()[B", "getScreenshotInfo", "()Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "getVisitId", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        @NotNull
        private final ScreenshotInfo screenshotInfo;
        @NotNull
        private final byte[] image;

        public Params(@NotNull String visitId, @NotNull ScreenshotInfo screenshotInfo, @NotNull byte[] image) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)screenshotInfo, (String)"screenshotInfo");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.visitId = visitId;
            this.screenshotInfo = screenshotInfo;
            this.image = image;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final ScreenshotInfo getScreenshotInfo() {
            return this.screenshotInfo;
        }

        @NotNull
        public final byte[] getImage() {
            return this.image;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.dynatrace.android.sessionreplay.core.usecases.screenshot.StoreScreenshotUseCase.Params");
            Params cfr_ignored_0 = (Params)other;
            if (!Intrinsics.areEqual((Object)this.visitId, (Object)((Params)other).visitId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.screenshotInfo, (Object)((Params)other).screenshotInfo)) {
                return false;
            }
            return Arrays.equals(this.image, ((Params)other).image);
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = 31 * result + this.screenshotInfo.hashCode();
            result = 31 * result + Arrays.hashCode(this.image);
            return result;
        }

        @NotNull
        public final String component1() {
            return this.visitId;
        }

        @NotNull
        public final ScreenshotInfo component2() {
            return this.screenshotInfo;
        }

        @NotNull
        public final byte[] component3() {
            return this.image;
        }

        @NotNull
        public final Params copy(@NotNull String visitId, @NotNull ScreenshotInfo screenshotInfo, @NotNull byte[] image) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)screenshotInfo, (String)"screenshotInfo");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new Params(visitId, screenshotInfo, image);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, ScreenshotInfo screenshotInfo, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.visitId;
            }
            if ((n & 2) != 0) {
                screenshotInfo = params.screenshotInfo;
            }
            if ((n & 4) != 0) {
                byArray = params.image;
            }
            return params.copy(string, screenshotInfo, byArray);
        }

        @NotNull
        public String toString() {
            return "Params(visitId=" + this.visitId + ", screenshotInfo=" + this.screenshotInfo + ", image=" + Arrays.toString(this.image) + ')';
        }
    }
}

