/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.screenshot;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.data.repositories.ImageRepository;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfo;
import com.dynatrace.android.sessionreplay.model.FileError;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "Lcom/dynatrace/android/sessionreplay/model/FileError;", "imageRepository", "Lcom/dynatrace/android/sessionreplay/data/repositories/ImageRepository;", "(Lcom/dynatrace/android/sessionreplay/data/repositories/ImageRepository;)V", "start", "params", "Params", "agent_release"})
public final class SaveScreenshotUseCase
implements UseCase<Params, Result<ScreenshotInfo, FileError>> {
    @NotNull
    private final ImageRepository imageRepository;

    public SaveScreenshotUseCase(@NotNull ImageRepository imageRepository) {
        Intrinsics.checkNotNullParameter((Object)imageRepository, (String)"imageRepository");
        this.imageRepository = imageRepository;
    }

    @Override
    @NotNull
    public Result<ScreenshotInfo, FileError> start(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.imageRepository.save(params.getScreenshotInfo(), params.getImage());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "screenshotInfo", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "image", "", "(Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;[B)V", "getImage", "()[B", "getScreenshotInfo", "()Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final ScreenshotInfo screenshotInfo;
        @NotNull
        private final byte[] image;

        public Params(@NotNull ScreenshotInfo screenshotInfo, @NotNull byte[] image) {
            Intrinsics.checkNotNullParameter((Object)screenshotInfo, (String)"screenshotInfo");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.screenshotInfo = screenshotInfo;
            this.image = image;
        }

        @NotNull
        public final ScreenshotInfo getScreenshotInfo() {
            return this.screenshotInfo;
        }

        @NotNull
        public final byte[] getImage() {
            return this.image;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.screenshotInfo, (Object)((Params)other).screenshotInfo)) {
                return false;
            }
            return Arrays.equals(this.image, ((Params)other).image);
        }

        public int hashCode() {
            int result = this.screenshotInfo.hashCode();
            result = 31 * result + Arrays.hashCode(this.image);
            return result;
        }

        @NotNull
        public final ScreenshotInfo component1() {
            return this.screenshotInfo;
        }

        @NotNull
        public final byte[] component2() {
            return this.image;
        }

        @NotNull
        public final Params copy(@NotNull ScreenshotInfo screenshotInfo, @NotNull byte[] image) {
            Intrinsics.checkNotNullParameter((Object)screenshotInfo, (String)"screenshotInfo");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new Params(screenshotInfo, image);
        }

        public static /* synthetic */ Params copy$default(Params params, ScreenshotInfo screenshotInfo, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                screenshotInfo = params.screenshotInfo;
            }
            if ((n & 2) != 0) {
                byArray = params.image;
            }
            return params.copy(screenshotInfo, byArray);
        }

        @NotNull
        public String toString() {
            return "Params(screenshotInfo=" + this.screenshotInfo + ", image=" + Arrays.toString(this.image) + ')';
        }
    }
}

