/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.screenshot;

import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.SaveLogUseCase;
import com.dynatrace.android.sessionreplay.core.utils.ExtensionsKt;
import com.dynatrace.android.sessionreplay.data.repositories.ImageRepository;
import com.dynatrace.android.sessionreplay.model.FileError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.ScreenshotError;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/model/ScreenshotError;", "imageRepository", "Lcom/dynatrace/android/sessionreplay/data/repositories/ImageRepository;", "saveLogUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;", "(Lcom/dynatrace/android/sessionreplay/data/repositories/ImageRepository;Lcom/dynatrace/android/sessionreplay/core/usecases/log/SaveLogUseCase;)V", "start", "params", "Params", "agent_release"})
public final class GetScreenshotUseCase
implements UseCase<Params, Result<byte[], ScreenshotError>> {
    @NotNull
    private final ImageRepository imageRepository;
    @NotNull
    private final SaveLogUseCase saveLogUseCase;

    public GetScreenshotUseCase(@NotNull ImageRepository imageRepository, @NotNull SaveLogUseCase saveLogUseCase) {
        Intrinsics.checkNotNullParameter((Object)imageRepository, (String)"imageRepository");
        Intrinsics.checkNotNullParameter((Object)saveLogUseCase, (String)"saveLogUseCase");
        this.imageRepository = imageRepository;
        this.saveLogUseCase = saveLogUseCase;
    }

    @Override
    @NotNull
    public Result<byte[], ScreenshotError> start(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Result result = this.imageRepository.get(params.getScreenshotId());
        if (!(result instanceof Result.Success)) {
            if (result instanceof Result.Error) {
                FileError fileError = (FileError)((Result.Error)result).getError();
                ExtensionsKt.logError(this.saveLogUseCase, params.getVisitId(), "Error reading screenshot from storage: " + fileError);
                return fileError instanceof FileError.IOError ? (Result)new Result.Error((Object)new ScreenshotError.IOError(((FileError.IOError)fileError).getThrowable())) : (Result)new Result.Error((Object)ScreenshotError.NotFound.INSTANCE);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (Result)new Result.Success(((Result.Success)result).getData());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/GetScreenshotUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "screenshotId", "", "visitId", "(Ljava/lang/String;Ljava/lang/String;)V", "getScreenshotId", "()Ljava/lang/String;", "getVisitId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String screenshotId;
        @NotNull
        private final String visitId;

        public Params(@NotNull String screenshotId, @NotNull String visitId) {
            Intrinsics.checkNotNullParameter((Object)screenshotId, (String)"screenshotId");
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            this.screenshotId = screenshotId;
            this.visitId = visitId;
        }

        @NotNull
        public final String getScreenshotId() {
            return this.screenshotId;
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final String component1() {
            return this.screenshotId;
        }

        @NotNull
        public final String component2() {
            return this.visitId;
        }

        @NotNull
        public final Params copy(@NotNull String screenshotId, @NotNull String visitId) {
            Intrinsics.checkNotNullParameter((Object)screenshotId, (String)"screenshotId");
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            return new Params(screenshotId, visitId);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.screenshotId;
            }
            if ((n & 2) != 0) {
                string2 = params.visitId;
            }
            return params.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Params(screenshotId=" + this.screenshotId + ", visitId=" + this.visitId + ')';
        }

        public int hashCode() {
            int result = this.screenshotId.hashCode();
            result = result * 31 + this.visitId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.screenshotId, (Object)params.screenshotId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.visitId, (Object)params.visitId);
        }
    }
}

