/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.beacon;

import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.connection.DynatraceAPIService;
import com.dynatrace.android.sessionreplay.core.connection.restclient.Response;
import com.dynatrace.android.sessionreplay.core.manager.RetryManager;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.model.APIError;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/model/APIError;", "apiClient", "Lcom/dynatrace/android/sessionreplay/core/connection/DynatraceAPIService;", "retryManager", "Lcom/dynatrace/android/sessionreplay/core/manager/RetryManager;", "(Lcom/dynatrace/android/sessionreplay/core/connection/DynatraceAPIService;Lcom/dynatrace/android/sessionreplay/core/manager/RetryManager;)V", "getErrorOrNull", "jsonString", "isStatusError", "", "jsonObject", "Lorg/json/JSONObject;", "start", "params", "Params", "agent_release"})
public final class SendBeaconUseCase
implements UseCase<Params, Result<String, APIError>> {
    @NotNull
    private final DynatraceAPIService apiClient;
    @NotNull
    private final RetryManager retryManager;

    public SendBeaconUseCase(@NotNull DynatraceAPIService apiClient, @NotNull RetryManager retryManager) {
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)retryManager, (String)"retryManager");
        this.apiClient = apiClient;
        this.retryManager = retryManager;
    }

    @Override
    @NotNull
    public Result<String, APIError> start(@NotNull Params params) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Response response = this.apiClient.sendBeacon(new DynatraceAPIService.DynatraceAPIParams(params.getVisitId(), params.getData(), params.getKeepConnectionAlive()));
        if (response instanceof Response.Success) {
            String responseStr = ((Response.Success)response).getData();
            APIError aPIError = this.getErrorOrNull(responseStr);
            if (aPIError instanceof APIError.InvalidResponseFormat) {
                String string = responseStr.substring(0, Math.min(100, responseStr.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String responseHundred = string;
                DTLogger.INSTANCE.api("Invalid response format: " + responseHundred);
                result = (Result)new Result.Error((Object)new APIError.InvalidResponseFormat(responseHundred));
            } else if (aPIError instanceof APIError.ResponseStatusError) {
                DTLogger.INSTANCE.api("Response with status: ERROR");
                result = (Result)new Result.Error((Object)APIError.ResponseStatusError.INSTANCE);
            } else {
                this.retryManager.clearCounter();
                result = (Result)new Result.Success((Object)responseStr);
            }
        } else if (response instanceof Response.Error.NetworkError) {
            result = (Result)new Result.Error((Object)APIError.NetworkError.INSTANCE);
        } else if (response instanceof Response.Error.InvalidParameter) {
            result = (Result)new Result.Error((Object)new APIError.InvalidParameter(((Response.Error.InvalidParameter)response).getMessage()));
        } else {
            if (response instanceof Response.Error.ServerError) {
                return ((Response.Error.ServerError)response).getStatusCode() == 429 ? (Result)new Result.Error((Object)APIError.EmergencyStop.INSTANCE) : (Result)new Result.Error((Object)new APIError.GenericServerError(((Response.Error.ServerError)response).getStatusCode()));
            }
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final APIError getErrorOrNull(String jsonString) {
        APIError error = null;
        try {
            JSONObject body = new JSONObject(jsonString);
            if (this.isStatusError(body)) {
                return (APIError)APIError.ResponseStatusError.INSTANCE;
            }
        }
        catch (JSONException e) {
            error = (APIError)new APIError.InvalidResponseFormat(jsonString);
        }
        return error;
    }

    private final boolean isStatusError(JSONObject jsonObject) {
        JSONObject dynamicConfig;
        if (jsonObject.has("dynamicConfig") && (dynamicConfig = jsonObject.getJSONObject("dynamicConfig")).has("status")) {
            return StringsKt.equals((String)dynamicConfig.getString("status"), (String)"error", (boolean)true);
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/SendBeaconUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "visitId", "", "data", "", "keepConnectionAlive", "", "(Ljava/lang/String;[BZ)V", "getData", "()[B", "getKeepConnectionAlive", "()Z", "getVisitId", "()Ljava/lang/String;", "equals", "other", "", "hashCode", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final String visitId;
        @NotNull
        private final byte[] data;
        private final boolean keepConnectionAlive;

        public Params(@NotNull String visitId, @NotNull byte[] data, boolean keepConnectionAlive) {
            Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitId = visitId;
            this.data = data;
            this.keepConnectionAlive = keepConnectionAlive;
        }

        public /* synthetic */ Params(String string, byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, byArray, bl);
        }

        @NotNull
        public final String getVisitId() {
            return this.visitId;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public final boolean getKeepConnectionAlive() {
            return this.keepConnectionAlive;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Params ? Intrinsics.areEqual((Object)((Params)other).visitId, (Object)this.visitId) && Arrays.equals(((Params)other).data, this.data) && ((Params)other).keepConnectionAlive == this.keepConnectionAlive : false;
        }

        public int hashCode() {
            int result = this.visitId.hashCode();
            result = 31 * result + Arrays.hashCode(this.data);
            result = 31 * result + Boolean.hashCode(this.keepConnectionAlive);
            return result;
        }
    }
}

