/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.usecases.beacon;

import com.dynatrace.android.sessionreplay.core.configuration.TenantConfiguration;
import com.dynatrace.android.sessionreplay.core.usecases.UseCase;
import com.dynatrace.android.sessionreplay.core.usecases.selfmonitor.model.SelfMonitoringBeaconWithDataList;
import com.dynatrace.android.sessionreplay.model.BeaconSerializationError;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.selfmonitoring.SelfMonitoringSerializedData;
import com.dynatrace.protocols.mobile.sessionreplay.BeaconDataType;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.CannotSplitSelfMonitoringBeaconsException;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidSerializationDataException;
import com.dynatrace.protocols.mobile.sessionreplay.exceptions.InvalidTypeException;
import com.dynatrace.protocols.mobile.sessionreplay.tags.TaggedBeaconBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00030\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002J\"\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase;", "Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/core/usecases/selfmonitor/model/SelfMonitoringBeaconWithDataList;", "Lcom/dynatrace/android/sessionreplay/model/BeaconSerializationError$BeaconSerialization;", "tenantConfiguration", "Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;", "(Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;)V", "buildBeacons", "data", "Lcom/dynatrace/android/sessionreplay/model/selfmonitoring/SelfMonitoringSerializedData;", "concat", "", "list", "start", "params", "Params", "agent_release"})
@SourceDebugExtension(value={"SMAP\nBuildSelfMonitoringBeaconUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSelfMonitoringBeaconUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1549#2:74\n1620#2,3:75\n*S KotlinDebug\n*F\n+ 1 BuildSelfMonitoringBeaconUseCase.kt\ncom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase\n*L\n39#1:74\n39#1:75,3\n*E\n"})
public final class BuildSelfMonitoringBeaconUseCase
implements UseCase<Params, Result<List<? extends SelfMonitoringBeaconWithDataList>, BeaconSerializationError.BeaconSerialization>> {
    @NotNull
    private final TenantConfiguration tenantConfiguration;

    public BuildSelfMonitoringBeaconUseCase(@NotNull TenantConfiguration tenantConfiguration) {
        Intrinsics.checkNotNullParameter((Object)tenantConfiguration, (String)"tenantConfiguration");
        this.tenantConfiguration = tenantConfiguration;
    }

    @Override
    @NotNull
    public Result<List<SelfMonitoringBeaconWithDataList>, BeaconSerializationError.BeaconSerialization> start(@NotNull Params params) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<SelfMonitoringBeaconWithDataList> dataList = this.buildBeacons(params.getData());
        boolean bl = dataList.isEmpty();
        if (bl) {
            result = (Result)new Result.Error((Object)BeaconSerializationError.BeaconSerialization.INSTANCE);
        } else if (!bl) {
            result = (Result)new Result.Success(dataList);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final String concat(List<SelfMonitoringSerializedData> list) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SelfMonitoringSerializedData selfMonitoringSerializedData = (SelfMonitoringSerializedData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv)), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
    }

    private final List<SelfMonitoringBeaconWithDataList> buildBeacons(List<SelfMonitoringSerializedData> data) {
        List beaconsList = CollectionsKt.emptyList();
        if (!((Collection)data).isEmpty()) {
            Object object;
            try {
                List list = new TaggedBeaconBuilder().withType(BeaconDataType.SELF_MONITORING).withFullSessionMetrics(this.concat(data)).withMaxBeaconSizeInB(this.tenantConfiguration.getMaxBeaconSizeInBytes()).build();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"build(...)");
                object = CollectionsKt.first((List)list);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                object = CollectionsKt.listOf((Object)new SelfMonitoringBeaconWithDataList((byte[])object, data));
            }
            catch (InvalidSerializationDataException e) {
                object = CollectionsKt.emptyList();
            }
            catch (CannotSplitSelfMonitoringBeaconsException e) {
                List list = CollectionsKt.emptyList();
                if (data.size() > 1) {
                    List lists = CollectionsKt.chunked((Iterable)data, (int)(data.size() / 2));
                    list = CollectionsKt.plus((Collection)this.buildBeacons((List)CollectionsKt.first((List)lists)), (Iterable)this.buildBeacons((List)CollectionsKt.last((List)lists)));
                }
                return list;
            }
            catch (InvalidTypeException e) {
                object = CollectionsKt.emptyList();
            }
            beaconsList = object;
        }
        return beaconsList;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/android/sessionreplay/core/usecases/beacon/BuildSelfMonitoringBeaconUseCase$Params;", "Lcom/dynatrace/android/sessionreplay/core/usecases/UseCase$Params;", "data", "", "Lcom/dynatrace/android/sessionreplay/model/selfmonitoring/SelfMonitoringSerializedData;", "(Ljava/util/List;)V", "getData", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "agent_release"})
    public static final class Params
    extends UseCase.Params {
        @NotNull
        private final List<SelfMonitoringSerializedData> data;

        public Params(@NotNull List<SelfMonitoringSerializedData> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final List<SelfMonitoringSerializedData> getData() {
            return this.data;
        }

        @NotNull
        public final List<SelfMonitoringSerializedData> component1() {
            return this.data;
        }

        @NotNull
        public final Params copy(@NotNull List<SelfMonitoringSerializedData> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new Params(data);
        }

        public static /* synthetic */ Params copy$default(Params params, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = params.data;
            }
            return params.copy(list);
        }

        @NotNull
        public String toString() {
            return "Params(data=" + this.data + ')';
        }

        public int hashCode() {
            return ((Object)this.data).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            return Intrinsics.areEqual(this.data, params.data);
        }
    }
}

