/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.observer;

import android.content.Context;
import android.graphics.Bitmap;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.EspressoIdlingResource;
import com.dynatrace.android.sessionreplay.core.TrackingState;
import com.dynatrace.android.sessionreplay.core.executor.TaskKt;
import com.dynatrace.android.sessionreplay.core.executor.TaskManager;
import com.dynatrace.android.sessionreplay.core.manager.ContextExecutor;
import com.dynatrace.android.sessionreplay.core.usecases.event.TrackEventUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.log.SaveLogUseCase;
import com.dynatrace.android.sessionreplay.core.usecases.screenshot.SaveScreenshotUseCase;
import com.dynatrace.android.sessionreplay.core.utils.BitmapEncoder;
import com.dynatrace.android.sessionreplay.core.utils.DispatchersWrapper;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfo;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfoHelper;
import com.dynatrace.android.sessionreplay.model.AlertViewAction;
import com.dynatrace.android.sessionreplay.model.AlertViewEvent;
import com.dynatrace.android.sessionreplay.model.Checkpoint;
import com.dynatrace.android.sessionreplay.model.CompoundButtonAction;
import com.dynatrace.android.sessionreplay.model.CompoundButtonEvent;
import com.dynatrace.android.sessionreplay.model.CustomEvent;
import com.dynatrace.android.sessionreplay.model.DisplayViewEvent;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.EventType;
import com.dynatrace.android.sessionreplay.model.FileError;
import com.dynatrace.android.sessionreplay.model.FragmentEvent;
import com.dynatrace.android.sessionreplay.model.GenericEvent;
import com.dynatrace.android.sessionreplay.model.GestureEvent;
import com.dynatrace.android.sessionreplay.model.InputEndEvent;
import com.dynatrace.android.sessionreplay.model.InputKeystrokeEvent;
import com.dynatrace.android.sessionreplay.model.InputStartEvent;
import com.dynatrace.android.sessionreplay.model.KeyboardHiddenEvent;
import com.dynatrace.android.sessionreplay.model.KeyboardPosition;
import com.dynatrace.android.sessionreplay.model.KeyboardShownEvent;
import com.dynatrace.android.sessionreplay.model.LifecycleAction;
import com.dynatrace.android.sessionreplay.model.LifecycleEvent;
import com.dynatrace.android.sessionreplay.model.Log;
import com.dynatrace.android.sessionreplay.model.NavigationDrawerAction;
import com.dynatrace.android.sessionreplay.model.NavigationDrawerEvent;
import com.dynatrace.android.sessionreplay.model.NavigationEvent;
import com.dynatrace.android.sessionreplay.model.NavigationType;
import com.dynatrace.android.sessionreplay.model.ResolutionEvent;
import com.dynatrace.android.sessionreplay.model.Result;
import com.dynatrace.android.sessionreplay.model.ScrollEvent;
import com.dynatrace.android.sessionreplay.model.TableReloadEvent;
import com.dynatrace.android.sessionreplay.model.TouchEvent;
import com.dynatrace.android.sessionreplay.model.UIMetadata;
import com.dynatrace.android.sessionreplay.model.WebViewLoadEvent;
import com.dynatrace.android.sessionreplay.tracking.model.CheckpointMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.CompoundButtonMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.CustomMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.FragmentMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.GestureMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.InputEndMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.InputStartMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.KeyboardMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.KeystrokeMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.ResolutionMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.ScrollMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.TouchMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.WebViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import java.util.Date;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J2\u0010)\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u0010,\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010/\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u00100\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u00101\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u00102\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J2\u00103\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u00104\u001a\u0002052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u00106\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u00107\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u00108\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J2\u0010<\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010=\u001a\u00020>2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J(\u0010?\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010@\u001a\u00020AH\u0016J2\u0010B\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010C\u001a\u00020D2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u0010E\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010F\u001a\u00020G2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010H\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010I\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010J\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J2\u0010K\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010L\u001a\u00020M2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u0010N\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010O\u001a\u00020P2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010Q\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010R\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0016J2\u0010W\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010X\u001a\u00020Y2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020]0[2\u0006\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020`H\u0082@\u00a2\u0006\u0002\u0010aJ\u001c\u0010b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/dynatrace/android/sessionreplay/core/observer/EventsObserver;", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "contextExecutor", "Lcom/dynatrace/android/sessionreplay/core/manager/ContextExecutor;", "state", "Lcom/dynatrace/android/sessionreplay/core/TrackingState;", "taskManager", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskManager;", "screenshotInfoHelper", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfoHelper;", "saveTmpScreenshotUseCase", "Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase;", "dispatchersWrapper", "Lcom/dynatrace/android/sessionreplay/core/utils/DispatchersWrapper;", "(Lcom/dynatrace/android/sessionreplay/core/manager/ContextExecutor;Lcom/dynatrace/android/sessionreplay/core/TrackingState;Lcom/dynatrace/android/sessionreplay/core/executor/TaskManager;Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfoHelper;Lcom/dynatrace/android/sessionreplay/core/usecases/screenshot/SaveScreenshotUseCase;Lcom/dynatrace/android/sessionreplay/core/utils/DispatchersWrapper;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "enqueueEvent", "", "event", "Lcom/dynatrace/android/sessionreplay/model/Event;", "bitmap", "Landroid/graphics/Bitmap;", "enqueueLogTask", "context", "Landroid/content/Context;", "log", "Lcom/dynatrace/android/sessionreplay/model/Log;", "enqueueTrackEventTask", "visitId", "", "getUiMetadata", "Lcom/dynatrace/android/sessionreplay/model/UIMetadata;", "viewMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/ViewMetadata;", "isMasked", "", "onBackNavigation", "time", "Ljava/util/Date;", "onBackground", "onCompoundStateChanged", "compoundButtonMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/CompoundButtonMetadata;", "onCustom", "customMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/CustomMetadata;", "onDialogHidden", "onDialogShown", "onDisplay", "onForeground", "onFragmentShown", "fragmentMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/FragmentMetadata;", "onGenericEvent", "type", "onGesture", "gestureMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/GestureMetadata;", "onHomeNavigation", "onInputEnd", "inputEndMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/InputEndMetadata;", "onInputStart", "inputStartMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/InputStartMetadata;", "onKeyboardChange", "keyboardMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/KeyboardMetadata;", "onKeystroke", "keystrokeMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/KeystrokeMetadata;", "onNavigationDrawerClosed", "onNavigationDrawerOpened", "onRecentsNavigation", "onResolutionChange", "resolutionMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/ResolutionMetadata;", "onScroll", "scrollMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/ScrollMetadata;", "onTableReload", "onTouch", "systemTimestamp", "", "touchMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/TouchMetadata;", "onWebViewLoad", "webViewMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/WebViewMetadata;", "persistImage", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "Lcom/dynatrace/android/sessionreplay/model/FileError;", "screenshotInfo", "encodedBitmap", "", "(Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackEvent", "agent_release"})
@SourceDebugExtension(value={"SMAP\nEventsObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsObserver.kt\ncom/dynatrace/android/sessionreplay/core/observer/EventsObserver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,481:1\n1855#2,2:482\n1#3:484\n*S KotlinDebug\n*F\n+ 1 EventsObserver.kt\ncom/dynatrace/android/sessionreplay/core/observer/EventsObserver\n*L\n189#1:482,2\n*E\n"})
public final class EventsObserver
implements TrackingObserver {
    @NotNull
    private final ContextExecutor contextExecutor;
    @NotNull
    private final TrackingState state;
    @NotNull
    private final TaskManager taskManager;
    @NotNull
    private final ScreenshotInfoHelper screenshotInfoHelper;
    @NotNull
    private final SaveScreenshotUseCase saveTmpScreenshotUseCase;
    @NotNull
    private final DispatchersWrapper dispatchersWrapper;
    @NotNull
    private final CoroutineScope coroutineScope;

    public EventsObserver(@NotNull ContextExecutor contextExecutor, @NotNull TrackingState state, @NotNull TaskManager taskManager, @NotNull ScreenshotInfoHelper screenshotInfoHelper, @NotNull SaveScreenshotUseCase saveTmpScreenshotUseCase, @NotNull DispatchersWrapper dispatchersWrapper) {
        Intrinsics.checkNotNullParameter((Object)contextExecutor, (String)"contextExecutor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)taskManager, (String)"taskManager");
        Intrinsics.checkNotNullParameter((Object)screenshotInfoHelper, (String)"screenshotInfoHelper");
        Intrinsics.checkNotNullParameter((Object)saveTmpScreenshotUseCase, (String)"saveTmpScreenshotUseCase");
        Intrinsics.checkNotNullParameter((Object)dispatchersWrapper, (String)"dispatchersWrapper");
        this.contextExecutor = contextExecutor;
        this.state = state;
        this.taskManager = taskManager;
        this.screenshotInfoHelper = screenshotInfoHelper;
        this.saveTmpScreenshotUseCase = saveTmpScreenshotUseCase;
        this.dispatchersWrapper = dispatchersWrapper;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.dispatchersWrapper.getMainDispatcher().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    public /* synthetic */ EventsObserver(ContextExecutor contextExecutor, TrackingState trackingState, TaskManager taskManager, ScreenshotInfoHelper screenshotInfoHelper, SaveScreenshotUseCase saveScreenshotUseCase, DispatchersWrapper dispatchersWrapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            dispatchersWrapper = new DispatchersWrapper((CoroutineDispatcher)Dispatchers.getMain(), Dispatchers.getIO());
        }
        this(contextExecutor, trackingState, taskManager, screenshotInfoHelper, saveScreenshotUseCase, dispatchersWrapper);
    }

    public void onFragmentShown(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull FragmentMetadata fragmentMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)fragmentMetadata, (String)"fragmentMetadata");
        this.trackEvent((Event)new FragmentEvent(null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), fragmentMetadata.getName(), 13, null), bitmap);
    }

    public void onDialogShown(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        this.trackEvent((Event)new AlertViewEvent(AlertViewAction.APPEAR, null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null), bitmap);
    }

    public void onDialogHidden(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        this.trackEvent((Event)new AlertViewEvent(AlertViewAction.DISAPPEAR, null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null), bitmap);
    }

    public void onDisplay(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        DisplayViewEvent event = new DisplayViewEvent(null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 13, null);
        this.trackEvent((Event)event, bitmap);
    }

    public void onResolutionChange(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull ResolutionMetadata resolutionMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)resolutionMetadata, (String)"resolutionMetadata");
        ResolutionEvent event = new ResolutionEvent(resolutionMetadata.getOrientation(), viewMetadata.getViewHeight(), viewMetadata.getViewWidth(), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 104, null);
        this.trackEvent((Event)event, bitmap);
    }

    public void onTouch(@NotNull Date time, long systemTimestamp, @NotNull TouchMetadata touchMetadata) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)touchMetadata, (String)"touchMetadata");
        TouchEvent touchEvent = new TouchEvent(touchMetadata.getDuration(), touchMetadata.getX(), touchMetadata.getY(), systemTimestamp, null, time, 16, null);
        EventsObserver.trackEvent$default(this, (Event)touchEvent, null, 2, null);
    }

    public void onGesture(@NotNull Date time, @NotNull GestureMetadata gestureMetadata) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)gestureMetadata, (String)"gestureMetadata");
        GestureEvent gestureEvent = new GestureEvent(null, time, 1, null);
        Iterable $this$forEach$iv = gestureMetadata.getCheckpoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CheckpointMetadata ch = (CheckpointMetadata)element$iv;
            boolean bl = false;
            gestureEvent.addCheckpoint(new Checkpoint(ch.getTime() - time.getTime(), ch.getX(), ch.getY(), null, 8, null));
        }
        EventsObserver.trackEvent$default(this, (Event)gestureEvent, null, 2, null);
    }

    public void onTableReload(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        this.trackEvent((Event)new TableReloadEvent(null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 13, null), bitmap);
    }

    public void onCustom(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull CustomMetadata customMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)customMetadata, (String)"customMetadata");
        this.trackEvent((Event)new CustomEvent(customMetadata.getCustomName(), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null), bitmap);
    }

    public void onInputStart(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull InputStartMetadata inputStartMetadata) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)inputStartMetadata, (String)"inputStartMetadata");
        String string = inputStartMetadata.getField();
        String string2 = inputStartMetadata.getName();
        String string3 = inputStartMetadata.getValue();
        String string4 = inputStartMetadata.getInputModificationId();
        UIMetadata uIMetadata = this.getUiMetadata(viewMetadata, isMasked);
        EventsObserver.trackEvent$default(this, (Event)new InputStartEvent(string, string3, string2, string4, null, time, null, 0L, uIMetadata, 208, null), null, 2, null);
    }

    public void onInputEnd(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull InputEndMetadata inputEndMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)inputEndMetadata, (String)"inputEndMetadata");
        String string = inputEndMetadata.getField();
        String string2 = inputEndMetadata.getName();
        String string3 = inputEndMetadata.getValue();
        long l = inputEndMetadata.getDuration();
        String string4 = inputEndMetadata.getInputModificationId();
        UIMetadata uIMetadata = this.getUiMetadata(viewMetadata, isMasked);
        InputEndEvent inputEvent = new InputEndEvent(string, string3, l, string2, string4, null, time, null, 0L, uIMetadata, 416, null);
        this.trackEvent((Event)inputEvent, bitmap);
    }

    public void onKeystroke(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull KeystrokeMetadata keystrokeMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)keystrokeMetadata, (String)"keystrokeMetadata");
        InputKeystrokeEvent keystroke = new InputKeystrokeEvent(keystrokeMetadata.getKeystrokeValue(), keystrokeMetadata.getInputModificationId(), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 52, null);
        this.trackEvent((Event)keystroke, bitmap);
    }

    public void onScroll(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull ScrollMetadata scrollMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)scrollMetadata, (String)"scrollMetadata");
        this.trackEvent((Event)new ScrollEvent(scrollMetadata.getX(), scrollMetadata.getY(), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 52, null), bitmap);
    }

    public void onKeyboardChange(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull KeyboardMetadata keyboardMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)keyboardMetadata, (String)"keyboardMetadata");
        DTLogger.INSTANCE.tracking("Keyboard change [isOpen: " + keyboardMetadata.isOpen() + ']');
        Event event = keyboardMetadata.isOpen() ? (Event)new KeyboardShownEvent(new KeyboardPosition(keyboardMetadata.getX(), keyboardMetadata.getY(), keyboardMetadata.getWidth(), keyboardMetadata.getHeight()), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null) : (Event)new KeyboardHiddenEvent(null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 13, null);
        this.trackEvent(event, bitmap);
    }

    public void onNavigationDrawerOpened(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        this.trackEvent((Event)new NavigationDrawerEvent(NavigationDrawerAction.OPEN, null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null), bitmap);
    }

    public void onNavigationDrawerClosed(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        this.trackEvent((Event)new NavigationDrawerEvent(NavigationDrawerAction.CLOSE, null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null), bitmap);
    }

    public void onWebViewLoad(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull WebViewMetadata webViewMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)webViewMetadata, (String)"webViewMetadata");
        this.trackEvent((Event)new WebViewLoadEvent(webViewMetadata.getUrl(), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null), bitmap);
    }

    public void onForeground(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        EventsObserver.trackEvent$default(this, (Event)new LifecycleEvent(LifecycleAction.TO_FOREGROUND, null, time, 2, null), null, 2, null);
    }

    public void onBackground(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        EventsObserver.trackEvent$default(this, (Event)new LifecycleEvent(LifecycleAction.TO_BACKGROUND, null, time, 2, null), null, 2, null);
    }

    public void onBackNavigation(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        EventsObserver.trackEvent$default(this, (Event)new NavigationEvent(NavigationType.BACK, null, time, 2, null), null, 2, null);
    }

    public void onHomeNavigation(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        EventsObserver.trackEvent$default(this, (Event)new NavigationEvent(NavigationType.HOME, null, time, 2, null), null, 2, null);
    }

    public void onRecentsNavigation(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        EventsObserver.trackEvent$default(this, (Event)new NavigationEvent(NavigationType.RECENTS, null, time, 2, null), null, 2, null);
    }

    public void onGenericEvent(@NotNull Date time, @NotNull String type, @NotNull ViewMetadata viewMetadata, boolean isMasked, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        GenericEvent event = new GenericEvent(EventType.valueOf((String)type), null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null);
        this.trackEvent((Event)event, bitmap);
    }

    public void onCompoundStateChanged(@NotNull Date time, @NotNull ViewMetadata viewMetadata, boolean isMasked, @NotNull CompoundButtonMetadata compoundButtonMetadata, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)viewMetadata, (String)"viewMetadata");
        Intrinsics.checkNotNullParameter((Object)compoundButtonMetadata, (String)"compoundButtonMetadata");
        CompoundButtonAction action = CompoundButtonAction.valueOf((String)compoundButtonMetadata.getAction().name());
        CompoundButtonEvent event = new CompoundButtonEvent(action, null, time, null, 0L, this.getUiMetadata(viewMetadata, isMasked), 26, null);
        this.trackEvent((Event)event, bitmap);
    }

    private final void trackEvent(Event event, Bitmap bitmap) {
        block2: {
            Unit unit;
            String string = this.state.getCurrentVisitId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.enqueueEvent(event, bitmap);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            EventsObserver $this$trackEvent_u24lambda_u242 = this;
            boolean bl = false;
            DTLogger.INSTANCE.warning("There is no valid visit id");
        }
    }

    static /* synthetic */ void trackEvent$default(EventsObserver eventsObserver, Event event, Bitmap bitmap, int n, Object object) {
        if ((n & 2) != 0) {
            bitmap = null;
        }
        eventsObserver.trackEvent(event, bitmap);
    }

    private final void enqueueEvent(Event event, Bitmap bitmap) {
        EspressoIdlingResource.INSTANCE.increment$agent_release("EventsObserver: enqueueEvent " + event.getType());
        this.contextExecutor.execute((Function1<? super Context, Unit>)((Function1)new Function1<Context, Unit>(this, bitmap, event){
            final /* synthetic */ EventsObserver this$0;
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Event $event;
            {
                this.this$0 = $receiver;
                this.$bitmap = $bitmap;
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                BuildersKt.launch$default((CoroutineScope)EventsObserver.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$bitmap, this.this$0, this.$event, context, null){
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Bitmap $bitmap;
                    final /* synthetic */ EventsObserver this$0;
                    final /* synthetic */ Event $event;
                    final /* synthetic */ Context $context;
                    {
                        this.$bitmap = $bitmap;
                        this.this$0 = $receiver;
                        this.$event = $event;
                        this.$context = $context;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        block13: {
                            var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$launch = (CoroutineScope)this.L$0;
                                    v0 = this.$bitmap;
                                    if (v0 == null) break;
                                    var4_4 /* !! */  = v0;
                                    var5_5 = this.this$0;
                                    var6_6 = this.$bitmap;
                                    var7_7 = this.$event;
                                    var8_8 = this.$context;
                                    $i$a$-let-EventsObserver$enqueueEvent$1$1$1 = false;
                                    this.L$0 = $this$launch;
                                    this.L$1 = var5_5;
                                    this.L$2 = var7_7;
                                    this.L$3 = var8_8;
                                    this.label = 1;
                                    v1 = new BitmapEncoder(EventsObserver.access$getDispatchersWrapper$p(var5_5)).encode(var6_6, (Continuation<? super byte[]>)this);
                                    if (v1 == var16_2) {
                                        return var16_2;
                                    }
                                    ** GOTO lbl31
                                }
                                case 1: {
                                    $i$a$-let-EventsObserver$enqueueEvent$1$1$1 = false;
                                    var8_8 = (Context)this.L$3;
                                    var7_7 = (Event)this.L$2;
                                    var5_5 = (EventsObserver)this.L$1;
                                    $this$launch = (CoroutineScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl31:
                                    // 2 sources

                                    encodedBitmap = (byte[])v1;
                                    screenshotInfo = EventsObserver.access$getScreenshotInfoHelper$p(var5_5).getScreenshotInfo(encodedBitmap);
                                    v2 = EventsObserver.access$getState$p(var5_5).getCurrentVisitId();
                                    if (v2 == null) {
                                        return Unit.INSTANCE;
                                    }
                                    visitId = v2;
                                    this.L$0 = $this$launch;
                                    this.L$1 = var5_5;
                                    this.L$2 = var7_7;
                                    this.L$3 = var8_8;
                                    this.L$4 = visitId;
                                    this.label = 2;
                                    v3 = EventsObserver.access$persistImage(var5_5, screenshotInfo, encodedBitmap, (Continuation)this);
                                    if (v3 == var16_2) {
                                        return var16_2;
                                    }
                                    ** GOTO lbl56
                                }
                                case 2: {
                                    $i$a$-let-EventsObserver$enqueueEvent$1$1$1 = false;
                                    visitId = (String)this.L$4;
                                    var8_8 = (Context)this.L$3;
                                    var7_7 = (Event)this.L$2;
                                    var5_5 = (EventsObserver)this.L$1;
                                    $this$launch = (CoroutineScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl56:
                                    // 2 sources

                                    if ((result = (Result)v3) instanceof Result.Success) {
                                        var7_7.setScreenshotSize(((ScreenshotInfo)((Result.Success)result).getData()).getSize());
                                        var7_7.setScreenshotId(((ScreenshotInfo)((Result.Success)result).getData()).getId());
                                    } else if (result instanceof Result.Error) {
                                        errorMessage = "Error trying to persist screenshot to tmp for " + var7_7.getType() + " event: " + ((Result.Error)result).getError();
                                        DTLogger.INSTANCE.error(errorMessage);
                                        EventsObserver.access$enqueueLogTask(var5_5, var8_8, new Log(visitId, errorMessage, 0L, null, 12, null));
                                    }
                                    EventsObserver.access$enqueueTrackEventTask(var5_5, var8_8, visitId, var7_7);
                                    EspressoIdlingResource.INSTANCE.decrement$agent_release("EventsObserver: enqueueEvent screenshot " + var7_7.getType());
                                    v4 = Unit.INSTANCE;
                                    break block13;
                                }
                            }
                            v4 = null;
                        }
                        if (v4 == null) {
                            var3_18 = $this$launch;
                            var4_4 /* !! */  = this.this$0;
                            var5_5 = this.$context;
                            var6_6 = this.$event;
                            $i$a$-run-EventsObserver$enqueueEvent$1$1$2 = false;
                            v5 = EventsObserver.access$getState$p((EventsObserver)var4_4 /* !! */ ).getCurrentVisitId();
                            if (v5 == null) {
                                return Unit.INSTANCE;
                            }
                            visitId = v5;
                            EventsObserver.access$enqueueTrackEventTask((EventsObserver)var4_4 /* !! */ , (Context)var5_5, visitId, (Event)var6_6);
                            EspressoIdlingResource.INSTANCE.decrement$agent_release("EventsObserver: enqueueEvent without screenshot " + var6_6.getType());
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }));
    }

    static /* synthetic */ void enqueueEvent$default(EventsObserver eventsObserver, Event event, Bitmap bitmap, int n, Object object) {
        if ((n & 2) != 0) {
            bitmap = null;
        }
        eventsObserver.enqueueEvent(event, bitmap);
    }

    private final Object persistImage(ScreenshotInfo screenshotInfo, byte[] encodedBitmap, Continuation<? super Result<ScreenshotInfo, FileError>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatchersWrapper.getIoDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<ScreenshotInfo, FileError>>, Object>(this, screenshotInfo, encodedBitmap, null){
            int label;
            final /* synthetic */ EventsObserver this$0;
            final /* synthetic */ ScreenshotInfo $screenshotInfo;
            final /* synthetic */ byte[] $encodedBitmap;
            {
                this.this$0 = $receiver;
                this.$screenshotInfo = $screenshotInfo;
                this.$encodedBitmap = $encodedBitmap;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return EventsObserver.access$getSaveTmpScreenshotUseCase$p(this.this$0).start(new SaveScreenshotUseCase.Params(this.$screenshotInfo, this.$encodedBitmap));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<ScreenshotInfo, FileError>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void enqueueTrackEventTask(Context context, String visitId, Event event) {
        this.taskManager.enqueueTask(context, TaskKt.trackEventTask(new TrackEventUseCase.Params(visitId, event)));
    }

    private final void enqueueLogTask(Context context, Log log) {
        this.taskManager.enqueueTask(context, TaskKt.saveLogTask(new SaveLogUseCase.Params(log)));
    }

    private final UIMetadata getUiMetadata(ViewMetadata viewMetadata, boolean isMasked) {
        return new UIMetadata(viewMetadata.getViewHeight(), viewMetadata.getViewWidth(), viewMetadata.getPositionX(), viewMetadata.getPositionY(), isMasked);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(EventsObserver $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ DispatchersWrapper access$getDispatchersWrapper$p(EventsObserver $this) {
        return $this.dispatchersWrapper;
    }

    public static final /* synthetic */ ScreenshotInfoHelper access$getScreenshotInfoHelper$p(EventsObserver $this) {
        return $this.screenshotInfoHelper;
    }

    public static final /* synthetic */ TrackingState access$getState$p(EventsObserver $this) {
        return $this.state;
    }

    public static final /* synthetic */ Object access$persistImage(EventsObserver $this, ScreenshotInfo screenshotInfo, byte[] encodedBitmap, Continuation $completion) {
        return $this.persistImage(screenshotInfo, encodedBitmap, (Continuation<? super Result<ScreenshotInfo, FileError>>)$completion);
    }

    public static final /* synthetic */ void access$enqueueLogTask(EventsObserver $this, Context context, Log log) {
        $this.enqueueLogTask(context, log);
    }

    public static final /* synthetic */ void access$enqueueTrackEventTask(EventsObserver $this, Context context, String visitId, Event event) {
        $this.enqueueTrackEventTask(context, visitId, event);
    }

    public static final /* synthetic */ SaveScreenshotUseCase access$getSaveTmpScreenshotUseCase$p(EventsObserver $this) {
        return $this.saveTmpScreenshotUseCase;
    }
}

