/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.manager.listeners;

import android.app.Application;
import com.dynatrace.android.agent.AgentStateListener;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.core.EspressoIdlingResource;
import com.dynatrace.android.sessionreplay.core.configuration.ConfigurationWrapper;
import com.dynatrace.android.sessionreplay.core.manager.ConfigurationHandler;
import com.dynatrace.android.sessionreplay.core.manager.LifecycleHandler;
import com.dynatrace.android.sessionreplay.core.manager.SrParamCalculator;
import com.dynatrace.android.sessionreplay.core.manager.model.ReplayServerConfig;
import com.dynatrace.android.sessionreplay.core.manager.model.SelfMonitoringFlags;
import com.dynatrace.android.sessionreplay.core.manager.model.SessionStateConfiguration;
import com.dynatrace.android.sessionreplay.model.SessionState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J'\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016J$\u0010%\u001a\u00020\u00172\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/listeners/NotificationsListener;", "Lcom/dynatrace/android/agent/AgentStateListener;", "lifecycleHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/LifecycleHandler;", "configHandler", "Lcom/dynatrace/android/sessionreplay/core/manager/ConfigurationHandler;", "(Lcom/dynatrace/android/sessionreplay/core/manager/LifecycleHandler;Lcom/dynatrace/android/sessionreplay/core/manager/ConfigurationHandler;)V", "currentSession", "Lcom/dynatrace/android/sessionreplay/core/manager/listeners/NotificationsListener$CurrentSession;", "canSessionBeRecorded", "", "serverConfiguration", "Lcom/dynatrace/android/agent/conf/ServerConfiguration;", "rumSession", "Lcom/dynatrace/android/agent/data/Session;", "Lcom/dynatrace/android/sessionreplay/core/manager/model/RumSession;", "sessionState", "Lcom/dynatrace/android/sessionreplay/model/SessionState;", "canStartSession", "crashReplayOptIn", "screenRecordOptIn", "(Lcom/dynatrace/android/sessionreplay/core/manager/LifecycleHandler;ZLjava/lang/Boolean;)Z", "onAgentStarted", "", "application", "Landroid/app/Application;", "configuration", "Lcom/dynatrace/android/agent/conf/Configuration;", "privacyRules", "Lcom/dynatrace/android/agent/conf/PrivacyRules;", "onNewSessionStarted", "serverId", "", "srParameterListener", "Lcom/dynatrace/android/agent/AgentStateListener$SrParameterListener;", "onServerConfigurationChanged", "onServerIdForceChanged", "onSessionStatusChanged", "saveServerConfiguration", "CurrentSession", "agent_release"})
public final class NotificationsListener
implements AgentStateListener {
    @NotNull
    private final LifecycleHandler lifecycleHandler;
    @NotNull
    private final ConfigurationHandler configHandler;
    @Nullable
    private CurrentSession currentSession;

    public NotificationsListener(@NotNull LifecycleHandler lifecycleHandler2, @NotNull ConfigurationHandler configHandler) {
        Intrinsics.checkNotNullParameter((Object)lifecycleHandler2, (String)"lifecycleHandler");
        Intrinsics.checkNotNullParameter((Object)configHandler, (String)"configHandler");
        this.lifecycleHandler = lifecycleHandler2;
        this.configHandler = configHandler;
    }

    public void onAgentStarted(@NotNull Application application, @NotNull Configuration configuration, @NotNull ServerConfiguration serverConfiguration, @NotNull PrivacyRules privacyRules) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter((Object)privacyRules, (String)"privacyRules");
        if (configuration.userOptIn) {
            ReplayConfiguration replayConfiguration = serverConfiguration.getReplayConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)replayConfiguration, (String)"getReplayConfiguration(...)");
            this.lifecycleHandler.start(application, new ConfigurationWrapper(configuration, replayConfiguration));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onNewSessionStarted(@NotNull ServerConfiguration serverConfiguration, @NotNull Session rumSession, int serverId, @NotNull AgentStateListener.SrParameterListener srParameterListener) {
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter((Object)rumSession, (String)"rumSession");
        Intrinsics.checkNotNullParameter((Object)srParameterListener, (String)"srParameterListener");
        this.configHandler.calculateSrParameter(SrParamCalculator.NotificationType.NEW_SESSION, serverConfiguration, rumSession, (Function2<? super SessionStateConfiguration, ? super String, Unit>)((Function2)new Function2<SessionStateConfiguration, String, Unit>(srParameterListener, rumSession){
            final /* synthetic */ AgentStateListener.SrParameterListener $srParameterListener;
            final /* synthetic */ Session $rumSession;
            {
                this.$srParameterListener = $srParameterListener;
                this.$rumSession = $rumSession;
                super(2);
            }

            public final void invoke(@NotNull SessionStateConfiguration sessionStateConfiguration, @NotNull String srParameter) {
                Intrinsics.checkNotNullParameter((Object)sessionStateConfiguration, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)srParameter, (String)"srParameter");
                this.$srParameterListener.onSrParameterReady(this.$rumSession, srParameter);
            }
        }));
        sequenceNumber = rumSession.sequenceNumber;
        v0 = this.currentSession;
        oldVisitorId = v0 != null ? Long.valueOf(v0.getVisitorId()) : null;
        v1 = this.currentSession;
        oldSessionId = v1 != null ? Long.valueOf(v1.getSessionId()) : null;
        v2 = this.currentSession;
        oldSequenceNumber = v2 != null ? v2.getSequenceNumber() : null;
        crashReplayOptIn = rumSession.getPrivacyRules().getPrivacySettings().isCrashReplayOptedIn();
        screenRecordOptIn = rumSession.getPrivacyRules().getPrivacySettings().isScreenRecordOptedIn();
        this.currentSession = new CurrentSession(rumSession.visitorId, rumSession.sessionId, sequenceNumber, serverId, crashReplayOptIn);
        if (!this.canStartSession(this.lifecycleHandler, crashReplayOptIn, screenRecordOptIn)) {
            DTLogger.INSTANCE.info("Session can\u00b4t be created! crashReplayOptin = " + crashReplayOptIn + ", screenRecordOptin = " + screenRecordOptIn);
            this.lifecycleHandler.stop(false);
            return;
        }
        DTLogger.INSTANCE.info("New session started: visitorId=" + rumSession.visitorId + ", sessionId=" + rumSession.sessionId + ", sequenceNumber=" + rumSession.sequenceNumber + ", serverId=" + serverId);
        this.lifecycleHandler.record();
        v3 = oldVisitorId;
        var11_11 = rumSession.visitorId;
        if (v3 == null || v3 != var11_11) ** GOTO lbl-1000
        v4 = oldSessionId;
        var11_11 = rumSession.sessionId;
        if (v4 == null || v4 != var11_11) lbl-1000:
        // 2 sources

        {
            this.configHandler.startSession(rumSession.visitorId, rumSession.sessionId, sequenceNumber);
        } else {
            v5 = oldSequenceNumber;
            var11_12 = sequenceNumber;
            if (v5 == null || v5 != var11_12) {
                this.configHandler.updateVisitId(rumSession.visitorId, rumSession.sessionId, sequenceNumber);
            }
        }
        this.configHandler.updateServerId(serverId);
        EspressoIdlingResource.INSTANCE.increment$agent_release("New session notification for visitorId=" + rumSession.visitorId + ", sessionId=" + rumSession.sessionId);
    }

    public void onServerConfigurationChanged(@NotNull ServerConfiguration serverConfiguration) {
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        if (!this.lifecycleHandler.isStarted()) {
            return;
        }
        DTLogger.INSTANCE.info("New configuration received: " + serverConfiguration);
        this.saveServerConfiguration(serverConfiguration);
    }

    public void onServerIdForceChanged(int serverId) {
        if (!this.lifecycleHandler.isStarted()) {
            return;
        }
        DTLogger.INSTANCE.info("Server id changed: " + serverId);
        this.configHandler.updateServerId(serverId);
    }

    public void onSessionStatusChanged(@NotNull Session rumSession, @NotNull ServerConfiguration serverConfiguration, @NotNull AgentStateListener.SrParameterListener srParameterListener) {
        Intrinsics.checkNotNullParameter((Object)rumSession, (String)"rumSession");
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Intrinsics.checkNotNullParameter((Object)srParameterListener, (String)"srParameterListener");
        this.configHandler.calculateSrParameter(SrParamCalculator.NotificationType.STATUS_CHANGED, serverConfiguration, rumSession, (Function2<? super SessionStateConfiguration, ? super String, Unit>)((Function2)new Function2<SessionStateConfiguration, String, Unit>(srParameterListener, rumSession, this, serverConfiguration){
            final /* synthetic */ AgentStateListener.SrParameterListener $srParameterListener;
            final /* synthetic */ Session $rumSession;
            final /* synthetic */ NotificationsListener this$0;
            final /* synthetic */ ServerConfiguration $serverConfiguration;
            {
                this.$srParameterListener = $srParameterListener;
                this.$rumSession = $rumSession;
                this.this$0 = $receiver;
                this.$serverConfiguration = $serverConfiguration;
                super(2);
            }

            public final void invoke(@NotNull SessionStateConfiguration sessionStateConfig, @NotNull String srParameter) {
                Intrinsics.checkNotNullParameter((Object)sessionStateConfig, (String)"sessionStateConfig");
                Intrinsics.checkNotNullParameter((Object)srParameter, (String)"srParameter");
                this.$srParameterListener.onSrParameterReady(this.$rumSession, srParameter);
                if (!NotificationsListener.access$getConfigHandler$p(this.this$0).isCurrentSession(this.$rumSession)) {
                    return;
                }
                NotificationsListener.access$saveServerConfiguration(this.this$0, this.$serverConfiguration);
                SessionState sessionState = NotificationsListener.access$getConfigHandler$p(this.this$0).calculateSessionState(sessionStateConfig);
                if (NotificationsListener.access$canSessionBeRecorded(this.this$0, this.$serverConfiguration, this.$rumSession, sessionState)) {
                    NotificationsListener.access$getConfigHandler$p(this.this$0).updateCurrentSessionState(sessionState);
                } else {
                    DTLogger.INSTANCE.info("Session has to be stopped! rumActive=" + this.$rumSession.isActive() + ", recording=" + NotificationsListener.access$getLifecycleHandler$p(this.this$0).isRecording() + ", newState=" + sessionState);
                    NotificationsListener.access$setCurrentSession$p(this.this$0, null);
                    NotificationsListener.access$getLifecycleHandler$p(this.this$0).stop(true);
                }
            }
        }));
        EspressoIdlingResource.INSTANCE.decrement$agent_release("Session status changed for visitorId=" + rumSession.visitorId + ", sessionId=" + rumSession.sessionId);
    }

    private final boolean canSessionBeRecorded(ServerConfiguration serverConfiguration, Session rumSession, SessionState sessionState) {
        boolean rumActiveAndCapturing = serverConfiguration.isCaptureOn() && rumSession.isActive();
        boolean replayOnRecordingState = this.lifecycleHandler.isRecording() && sessionState != SessionState.RECORDING;
        return rumActiveAndCapturing && replayOnRecordingState;
    }

    private final void saveServerConfiguration(ServerConfiguration serverConfiguration) {
        ReplayConfiguration replayConfig = serverConfiguration.getReplayConfiguration();
        this.configHandler.updateServerConfiguration(new ReplayServerConfig(serverConfiguration.getServerId(), replayConfig.getRetentionTimeInMinutes(), serverConfiguration.getMaxBeaconSizeKb(), replayConfig.getProtocolVersion(), new SelfMonitoringFlags(replayConfig.getSelfMonitoring()), replayConfig.isPixelCopyEnabled(), replayConfig.isColorMaskingEnabled()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canStartSession(LifecycleHandler lifecycleHandler2, boolean crashReplayOptIn, Boolean screenRecordOptIn) {
        if (!lifecycleHandler2.isStarted()) return false;
        Boolean bl = screenRecordOptIn;
        if (!(bl != null ? bl : crashReplayOptIn)) return false;
        return true;
    }

    public static final /* synthetic */ ConfigurationHandler access$getConfigHandler$p(NotificationsListener $this) {
        return $this.configHandler;
    }

    public static final /* synthetic */ void access$saveServerConfiguration(NotificationsListener $this, ServerConfiguration serverConfiguration) {
        $this.saveServerConfiguration(serverConfiguration);
    }

    public static final /* synthetic */ boolean access$canSessionBeRecorded(NotificationsListener $this, ServerConfiguration serverConfiguration, Session rumSession, SessionState sessionState) {
        return $this.canSessionBeRecorded(serverConfiguration, rumSession, sessionState);
    }

    public static final /* synthetic */ LifecycleHandler access$getLifecycleHandler$p(NotificationsListener $this) {
        return $this.lifecycleHandler;
    }

    public static final /* synthetic */ void access$setCurrentSession$p(NotificationsListener $this, CurrentSession currentSession) {
        $this.currentSession = currentSession;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003JB\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/dynatrace/android/sessionreplay/core/manager/listeners/NotificationsListener$CurrentSession;", "", "visitorId", "", "sessionId", "sequenceNumber", "", "serverId", "crashReplayOptIn", "", "(JJLjava/lang/Integer;IZ)V", "getCrashReplayOptIn", "()Z", "getSequenceNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getServerId", "()I", "getSessionId", "()J", "getVisitorId", "component1", "component2", "component3", "component4", "component5", "copy", "(JJLjava/lang/Integer;IZ)Lcom/dynatrace/android/sessionreplay/core/manager/listeners/NotificationsListener$CurrentSession;", "equals", "other", "hashCode", "toString", "", "agent_release"})
    private static final class CurrentSession {
        private final long visitorId;
        private final long sessionId;
        @Nullable
        private final Integer sequenceNumber;
        private final int serverId;
        private final boolean crashReplayOptIn;

        public CurrentSession(long visitorId, long sessionId, @Nullable Integer sequenceNumber, int serverId, boolean crashReplayOptIn) {
            this.visitorId = visitorId;
            this.sessionId = sessionId;
            this.sequenceNumber = sequenceNumber;
            this.serverId = serverId;
            this.crashReplayOptIn = crashReplayOptIn;
        }

        public final long getVisitorId() {
            return this.visitorId;
        }

        public final long getSessionId() {
            return this.sessionId;
        }

        @Nullable
        public final Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final int getServerId() {
            return this.serverId;
        }

        public final boolean getCrashReplayOptIn() {
            return this.crashReplayOptIn;
        }

        public final long component1() {
            return this.visitorId;
        }

        public final long component2() {
            return this.sessionId;
        }

        @Nullable
        public final Integer component3() {
            return this.sequenceNumber;
        }

        public final int component4() {
            return this.serverId;
        }

        public final boolean component5() {
            return this.crashReplayOptIn;
        }

        @NotNull
        public final CurrentSession copy(long visitorId, long sessionId, @Nullable Integer sequenceNumber, int serverId, boolean crashReplayOptIn) {
            return new CurrentSession(visitorId, sessionId, sequenceNumber, serverId, crashReplayOptIn);
        }

        public static /* synthetic */ CurrentSession copy$default(CurrentSession currentSession, long l, long l2, Integer n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = currentSession.visitorId;
            }
            if ((n3 & 2) != 0) {
                l2 = currentSession.sessionId;
            }
            if ((n3 & 4) != 0) {
                n = currentSession.sequenceNumber;
            }
            if ((n3 & 8) != 0) {
                n2 = currentSession.serverId;
            }
            if ((n3 & 0x10) != 0) {
                bl = currentSession.crashReplayOptIn;
            }
            return currentSession.copy(l, l2, n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "CurrentSession(visitorId=" + this.visitorId + ", sessionId=" + this.sessionId + ", sequenceNumber=" + this.sequenceNumber + ", serverId=" + this.serverId + ", crashReplayOptIn=" + this.crashReplayOptIn + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.visitorId);
            result = result * 31 + Long.hashCode(this.sessionId);
            result = result * 31 + (this.sequenceNumber == null ? 0 : ((Object)this.sequenceNumber).hashCode());
            result = result * 31 + Integer.hashCode(this.serverId);
            result = result * 31 + Boolean.hashCode(this.crashReplayOptIn);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentSession)) {
                return false;
            }
            CurrentSession currentSession = (CurrentSession)other;
            if (this.visitorId != currentSession.visitorId) {
                return false;
            }
            if (this.sessionId != currentSession.sessionId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sequenceNumber, (Object)currentSession.sequenceNumber)) {
                return false;
            }
            if (this.serverId != currentSession.serverId) {
                return false;
            }
            return this.crashReplayOptIn == currentSession.crashReplayOptIn;
        }
    }
}

