/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.injection;

import android.content.Context;
import com.dynatrace.android.sessionreplay.core.configuration.ConfigurationController;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatusProvider;
import com.dynatrace.android.sessionreplay.core.connection.NetworkStatusProviderImpl;
import com.dynatrace.android.sessionreplay.core.connection.SyncDynatraceAPIService;
import com.dynatrace.android.sessionreplay.core.connection.restclient.SyncRestClient;
import com.dynatrace.android.sessionreplay.core.executor.TaskExecutor;
import com.dynatrace.android.sessionreplay.core.executor.TaskExecutorImpl;
import com.dynatrace.android.sessionreplay.core.executor.services.SessionStopHandler;
import com.dynatrace.android.sessionreplay.core.injection.ComplexUseCaseFactory;
import com.dynatrace.android.sessionreplay.core.injection.DataAccessUseCaseFactory;
import com.dynatrace.android.sessionreplay.core.injection.SerializationUseCaseFactory;
import com.dynatrace.android.sessionreplay.core.manager.RetryManagerImpl;
import com.dynatrace.android.sessionreplay.core.utils.SystemTimeProvider;
import com.dynatrace.android.sessionreplay.data.daos.ImageDAO;
import com.dynatrace.android.sessionreplay.data.daos.localstorage.LocalStorageImageDAO;
import com.dynatrace.android.sessionreplay.data.db.DatabaseManager;
import com.dynatrace.android.sessionreplay.data.repositories.DataJobRepository;
import com.dynatrace.android.sessionreplay.data.repositories.EventRepository;
import com.dynatrace.android.sessionreplay.data.repositories.ImageRepository;
import com.dynatrace.android.sessionreplay.data.repositories.LogRepository;
import com.dynatrace.android.sessionreplay.data.repositories.ScreenshotJobRepository;
import com.dynatrace.android.sessionreplay.data.repositories.SelfMonitoringRepository;
import com.dynatrace.android.sessionreplay.data.repositories.SessionImageRepository;
import com.dynatrace.android.sessionreplay.data.repositories.SessionRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/core/injection/AgentInjection;", "", "networkStatusProvider", "Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;", "taskExecutor", "Lcom/dynatrace/android/sessionreplay/core/executor/TaskExecutor;", "dataAccessUseCaseFactory", "Lcom/dynatrace/android/sessionreplay/core/injection/DataAccessUseCaseFactory;", "sessionStopHandler", "Lcom/dynatrace/android/sessionreplay/core/executor/services/SessionStopHandler;", "(Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;Lcom/dynatrace/android/sessionreplay/core/executor/TaskExecutor;Lcom/dynatrace/android/sessionreplay/core/injection/DataAccessUseCaseFactory;Lcom/dynatrace/android/sessionreplay/core/executor/services/SessionStopHandler;)V", "getDataAccessUseCaseFactory", "()Lcom/dynatrace/android/sessionreplay/core/injection/DataAccessUseCaseFactory;", "getNetworkStatusProvider", "()Lcom/dynatrace/android/sessionreplay/core/connection/NetworkStatusProvider;", "getSessionStopHandler", "()Lcom/dynatrace/android/sessionreplay/core/executor/services/SessionStopHandler;", "getTaskExecutor", "()Lcom/dynatrace/android/sessionreplay/core/executor/TaskExecutor;", "Companion", "agent_release"})
public final class AgentInjection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkStatusProvider networkStatusProvider;
    @NotNull
    private final TaskExecutor taskExecutor;
    @NotNull
    private final DataAccessUseCaseFactory dataAccessUseCaseFactory;
    @NotNull
    private final SessionStopHandler sessionStopHandler;
    @Nullable
    private static AgentInjection INSTANCE;

    private AgentInjection(NetworkStatusProvider networkStatusProvider, TaskExecutor taskExecutor, DataAccessUseCaseFactory dataAccessUseCaseFactory, SessionStopHandler sessionStopHandler) {
        this.networkStatusProvider = networkStatusProvider;
        this.taskExecutor = taskExecutor;
        this.dataAccessUseCaseFactory = dataAccessUseCaseFactory;
        this.sessionStopHandler = sessionStopHandler;
    }

    @NotNull
    public final NetworkStatusProvider getNetworkStatusProvider() {
        return this.networkStatusProvider;
    }

    @NotNull
    public final TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @NotNull
    public final DataAccessUseCaseFactory getDataAccessUseCaseFactory() {
        return this.dataAccessUseCaseFactory;
    }

    @NotNull
    public final SessionStopHandler getSessionStopHandler() {
        return this.sessionStopHandler;
    }

    public /* synthetic */ AgentInjection(NetworkStatusProvider networkStatusProvider, TaskExecutor taskExecutor, DataAccessUseCaseFactory dataAccessUseCaseFactory, SessionStopHandler sessionStopHandler, DefaultConstructorMarker $constructor_marker) {
        this(networkStatusProvider, taskExecutor, dataAccessUseCaseFactory, sessionStopHandler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/dynatrace/android/sessionreplay/core/injection/AgentInjection$Companion;", "", "()V", "INSTANCE", "Lcom/dynatrace/android/sessionreplay/core/injection/AgentInjection;", "buildInstance", "context", "Landroid/content/Context;", "get", "init", "", "appContext", "agent_release"})
    @SourceDebugExtension(value={"SMAP\nAgentInjection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentInjection.kt\ncom/dynatrace/android/sessionreplay/core/injection/AgentInjection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgentInjection get() {
            AgentInjection agentInjection = INSTANCE;
            if (agentInjection == null) {
                throw new IllegalStateException("You should initialize injection before using it!".toString());
            }
            return agentInjection;
        }

        public final void init(@NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            AgentInjection agentInjection = INSTANCE;
            if (agentInjection == null) {
                AgentInjection agentInjection2;
                AgentInjection it = agentInjection2 = this.buildInstance(appContext);
                boolean bl = false;
                INSTANCE = it;
                agentInjection = agentInjection2;
            }
        }

        private final AgentInjection buildInstance(Context context) {
            ConfigurationController configurationController = new ConfigurationController(context);
            DatabaseManager dbManager = DatabaseManager.Companion.getInstance(context);
            DataJobRepository dataJobRepository = new DataJobRepository(dbManager.getDataJobDAO());
            ScreenshotJobRepository screenshotJobRepository = new ScreenshotJobRepository(dbManager.getScreenshotJobDAO());
            SessionImageRepository sessionImageRepository = new SessionImageRepository(dbManager.getSessionImageDAO());
            SessionRepository sessionRepository = new SessionRepository(dbManager.getSessionDAO());
            EventRepository eventRepository = new EventRepository(dbManager.getEventDAO());
            LogRepository logRepository = new LogRepository(dbManager.getLogDAO());
            ImageRepository imageRepository = new ImageRepository((ImageDAO)new LocalStorageImageDAO.Final(context), 0L, 2, null);
            ImageRepository tmpImageRepository = new ImageRepository((ImageDAO)new LocalStorageImageDAO.Tmp(context), 0L, 2, null);
            SelfMonitoringRepository selfMonitoringRepository = new SelfMonitoringRepository(dbManager.getSelfMonitoringDAO());
            SyncDynatraceAPIService apiService = new SyncDynatraceAPIService(new SyncRestClient(), configurationController);
            NetworkStatusProviderImpl networkStatusProvider = new NetworkStatusProviderImpl(null, 1, null);
            SessionStopHandler sessionStopHandler = new SessionStopHandler();
            RetryManagerImpl retryManager = new RetryManagerImpl();
            SerializationUseCaseFactory serializationUseCaseFactory = new SerializationUseCaseFactory(configurationController);
            DataAccessUseCaseFactory dataAccessUseCaseFactory = new DataAccessUseCaseFactory(dataJobRepository, screenshotJobRepository, sessionImageRepository, sessionRepository, eventRepository, logRepository, imageRepository, tmpImageRepository, selfMonitoringRepository, apiService, configurationController, retryManager);
            ComplexUseCaseFactory complexUseCaseFactory = new ComplexUseCaseFactory(dataAccessUseCaseFactory, serializationUseCaseFactory, configurationController, networkStatusProvider, sessionStopHandler, retryManager, new SystemTimeProvider());
            TaskExecutorImpl taskExecutor = new TaskExecutorImpl(dataAccessUseCaseFactory, complexUseCaseFactory);
            return new AgentInjection(networkStatusProvider, taskExecutor, dataAccessUseCaseFactory, sessionStopHandler, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

