/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.configuration.masking;

import android.view.View;
import android.webkit.WebView;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioGroup;
import android.widget.TextView;
import androidx.compose.ui.platform.ComposeView;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.configuration.NativeMaskingConfigurationProvider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u001d\b\u0004\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\nH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\"\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0003\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig;", "Lcom/dynatrace/android/sessionreplay/tracking/configuration/NativeMaskingConfigurationProvider;", "maskedViewsSet", "", "Ljava/lang/Class;", "Landroid/view/View;", "(Ljava/util/Set;)V", "getMaskedViewsSet", "()Ljava/util/Set;", "getMaskedIds", "", "", "getMaskedViews", "getNonMaskedIds", "Companion", "Custom", "Safe", "Safest", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Custom;", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Safe;", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Safest;", "agent_release"})
public abstract class MaskingLevelConfig
implements NativeMaskingConfigurationProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Class<? extends View>> maskedViewsSet;

    private MaskingLevelConfig(Set<Class<? extends View>> maskedViewsSet) {
        this.maskedViewsSet = maskedViewsSet;
    }

    @NotNull
    protected final Set<Class<? extends View>> getMaskedViewsSet() {
        return this.maskedViewsSet;
    }

    @NotNull
    public Set<Class<? extends View>> getMaskedViews() {
        return this.maskedViewsSet;
    }

    @NotNull
    public Set<Integer> getMaskedIds() {
        return SetsKt.emptySet();
    }

    @NotNull
    public Set<Integer> getNonMaskedIds() {
        return SetsKt.emptySet();
    }

    public /* synthetic */ MaskingLevelConfig(Set maskedViewsSet, DefaultConstructorMarker $constructor_marker) {
        this(maskedViewsSet);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002J\u0016\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0007H\u0002J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0007H\u0002J\u001a\u0010\t\u001a\u00020\n*\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Companion;", "", "()V", "getTextInputLayoutClass", "Ljava/lang/Class;", "Landroid/view/View;", "safeMaskedViews", "", "safestMaskedViews", "tryAddViewClasses", "", "agent_release"})
    private static final class Companion {
        private Companion() {
        }

        private final Set<Class<? extends View>> safeMaskedViews() {
            Object[] objectArray = new Class[]{EditText.class};
            Set views = SetsKt.mutableSetOf((Object[])objectArray);
            this.tryAddViewClasses(views);
            return views;
        }

        private final Set<Class<? extends View>> safestMaskedViews() {
            Object[] objectArray = new Class[]{EditText.class, RadioGroup.class, CompoundButton.class, TextView.class, ImageView.class, WebView.class};
            Set views = SetsKt.mutableSetOf((Object[])objectArray);
            this.tryAddViewClasses(views);
            return views;
        }

        private final void tryAddViewClasses(Set<Class<? extends View>> $this$tryAddViewClasses) {
            try {
                $this$tryAddViewClasses.add(this.getTextInputLayoutClass());
            }
            catch (Throwable e) {
                DTLogger.INSTANCE.info("Class not found with error: " + e.getLocalizedMessage());
            }
            try {
                $this$tryAddViewClasses.add(ComposeView.class);
            }
            catch (Throwable e) {
                DTLogger.INSTANCE.info("Class not found with error: " + e.getLocalizedMessage());
            }
        }

        private final Class<? extends View> getTextInputLayoutClass() {
            String textInputLayoutClassName = "com.google.android.material.textfield.TextInputLayout";
            Class<?> clazz = Class.forName(textInputLayoutClassName);
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out android.view.View>");
            return clazz;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0016\u0010\u000b\u001a\u00020\b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rJ\u001c\u0010\u000f\u001a\u00020\b2\u0014\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\nJ\u0014\u0010\u0011\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0006\u0010\u0014\u001a\u00020\bJ\u0014\u0010\u0015\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0016\u0010\u0016\u001a\u00020\b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rJ\u0014\u0010\u0017\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Custom;", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig;", "()V", "maskedIds", "", "", "nonMaskedIds", "addMaskedIds", "", "ids", "", "addMaskedView", "viewClass", "Ljava/lang/Class;", "Landroid/view/View;", "addMaskedViews", "viewClasses", "addNonMaskedIds", "getMaskedIds", "getNonMaskedIds", "removeAllMaskedViews", "removeMaskedIds", "removeMaskedView", "removeNonMaskedIds", "agent_release"})
    public static final class Custom
    extends MaskingLevelConfig {
        @NotNull
        private final Set<Integer> maskedIds = new LinkedHashSet();
        @NotNull
        private final Set<Integer> nonMaskedIds = new LinkedHashSet();

        public Custom() {
            super(Companion.safestMaskedViews(), null);
        }

        @Override
        @NotNull
        public Set<Integer> getMaskedIds() {
            return this.maskedIds;
        }

        @Override
        @NotNull
        public Set<Integer> getNonMaskedIds() {
            return this.nonMaskedIds;
        }

        public final void addMaskedIds(@NotNull Set<Integer> ids) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            this.maskedIds.addAll((Collection<Integer>)ids);
        }

        public final void removeMaskedIds(@NotNull Set<Integer> ids) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            this.maskedIds.removeAll((Collection)ids);
        }

        public final void addNonMaskedIds(@NotNull Set<Integer> ids) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            this.nonMaskedIds.addAll((Collection<Integer>)ids);
        }

        public final void removeNonMaskedIds(@NotNull Set<Integer> ids) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            this.nonMaskedIds.removeAll((Collection)ids);
        }

        public final void addMaskedView(@NotNull Class<? extends View> viewClass) {
            Intrinsics.checkNotNullParameter(viewClass, (String)"viewClass");
            this.getMaskedViewsSet().add(viewClass);
        }

        public final void addMaskedViews(@NotNull Set<? extends Class<? extends View>> viewClasses) {
            Intrinsics.checkNotNullParameter(viewClasses, (String)"viewClasses");
            this.getMaskedViewsSet().addAll((Collection<Class<? extends View>>)viewClasses);
        }

        public final void removeMaskedView(@NotNull Class<? extends View> viewClass) {
            Intrinsics.checkNotNullParameter(viewClass, (String)"viewClass");
            this.getMaskedViewsSet().remove(viewClass);
        }

        public final void removeAllMaskedViews() {
            this.getMaskedViewsSet().clear();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Safe;", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig;", "()V", "agent_release"})
    public static final class Safe
    extends MaskingLevelConfig {
        @NotNull
        public static final Safe INSTANCE = new Safe();

        private Safe() {
            super(Companion.safeMaskedViews(), null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig$Safest;", "Lcom/dynatrace/android/sessionreplay/core/configuration/masking/MaskingLevelConfig;", "()V", "agent_release"})
    public static final class Safest
    extends MaskingLevelConfig {
        @NotNull
        public static final Safest INSTANCE = new Safest();

        private Safest() {
            super(Companion.safestMaskedViews(), null);
        }
    }
}

