/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.core.configuration;

import android.content.Context;
import android.content.SharedPreferences;
import com.dynatrace.android.sessionreplay.core.configuration.AgentConfiguration;
import com.dynatrace.android.sessionreplay.core.configuration.AppConfiguration;
import com.dynatrace.android.sessionreplay.core.configuration.NetworkConfiguration;
import com.dynatrace.android.sessionreplay.core.configuration.TenantConfiguration;
import com.dynatrace.android.sessionreplay.core.configuration.TransmissionMode;
import com.dynatrace.android.sessionreplay.core.utils.UnitConversionKt;
import com.dynatrace.android.sessionreplay.model.MillisKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001c\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001<B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0016J\u0015\u0010\u001c\u001a\u00020\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0017J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0011J\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020!J\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020!J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u0013J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0015\u00f8\u0001\u0001\u00a2\u0006\u0004\b.\u0010/J\u000e\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u0013J\u000e\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020!J\u000e\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u0013J\u000e\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0013J\u000e\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u0011J\u000e\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u001fR\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006="}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/ConfigurationController;", "Lcom/dynatrace/android/sessionreplay/core/configuration/TenantConfiguration;", "Lcom/dynatrace/android/sessionreplay/core/configuration/AgentConfiguration;", "Lcom/dynatrace/android/sessionreplay/core/configuration/NetworkConfiguration;", "Lcom/dynatrace/android/sessionreplay/core/configuration/AppConfiguration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "sharedPrefs", "Landroid/content/SharedPreferences;", "getSharedPrefs", "()Landroid/content/SharedPreferences;", "sharedPrefs$delegate", "Lkotlin/Lazy;", "clearConfigs", "", "getAppId", "", "getDataProtocolVersion", "", "getLongRetentionTime", "Lcom/dynatrace/android/sessionreplay/model/Millis;", "getLongRetentionTime--CYLg48", "()J", "getMaxBeaconSizeInBytes", "getSelfMonitoringFlags", "getServerId", "getServerUrl", "getShortRetentionTime", "getShortRetentionTime--CYLg48", "getTransmissionMode", "Lcom/dynatrace/android/sessionreplay/core/configuration/TransmissionMode;", "isCertificateValidationEnabled", "", "isColorMaskingEnabled", "isPixelCopyEnabled", "setAppId", "appId", "setCertificateValidation", "validate", "setColorMaskingEnabled", "colorMaskingEnabled", "setDataProtocolVersion", "dataProtocolVersion", "setLongRetentionTime", "retentionTimeInMillis", "setLongRetentionTime-qBMM6oc", "(J)V", "setMaxBeaconSizeInBytes", "maxBeaconSizeInB", "setPixelCopyEnabled", "pixelCopyEnabled", "setSelfMonitoring", "selfMonitoring", "setServerId", "serverId", "setServerUrl", "serverUrl", "setTransmissionMode", "transmissionMode", "Companion", "agent_release"})
@SourceDebugExtension(value={"SMAP\nConfigurationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationController.kt\ncom/dynatrace/android/sessionreplay/core/configuration/ConfigurationController\n+ 2 Extensions.kt\ncom/dynatrace/android/sessionreplay/core/utils/ExtensionsKt\n*L\n1#1,148:1\n14#2,10:149\n14#2,10:159\n14#2,10:169\n14#2,10:179\n14#2,10:189\n14#2,10:199\n14#2,10:209\n14#2,10:219\n14#2,10:229\n14#2,10:239\n14#2,10:249\n14#2,10:259\n*S KotlinDebug\n*F\n+ 1 ConfigurationController.kt\ncom/dynatrace/android/sessionreplay/core/configuration/ConfigurationController\n*L\n78#1:149,10\n82#1:159,10\n86#1:169,10\n90#1:179,10\n94#1:189,10\n100#1:199,10\n106#1:209,10\n110#1:219,10\n114#1:229,10\n118#1:239,10\n122#1:249,10\n126#1:259,10\n*E\n"})
public final class ConfigurationController
implements TenantConfiguration,
AgentConfiguration,
NetworkConfiguration,
AppConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy sharedPrefs$delegate;
    @NotNull
    private static final String SESSION_REPLAY_PREFS = "session_replay_preferences";
    @NotNull
    private static final String TRANSMISSION_MODE_KEY = "transmission_mode";
    @NotNull
    private static final String SERVER_ID_KEY = "server_id";
    @NotNull
    private static final String SERVER_URL_KEY = "server_url";
    @NotNull
    private static final String APP_ID_KEY = "app_id";
    @NotNull
    private static final String MAX_BEACON_SIZE_IN_BYTES = "max_beacon_size";
    @NotNull
    private static final String DATA_PROTOCOL_VERSION = "protocol_version";
    @NotNull
    private static final String CERTIFICATE_VALIDATION_KEY = "certificate_validation";
    @NotNull
    private static final String SELFMONITORING_KEY = "selfmonitoring";
    @NotNull
    private static final String PIXEL_COPY_ENABLED = "pixelCopy";
    @NotNull
    private static final String COLOR_MASKING_ENABLED = "color_masking";
    @NotNull
    private static final String LONG_RETENTION_TIME_KEY = "long_retention_time";
    private static final long SHORT_RETENTION_TIME_IN_MILLIS = 600000L;
    public static final int DEFAULT_DATA_PROTOCOL_VERSION = 1;
    private static final int DEFAULT_MAX_BEACON_SIZE = UnitConversionKt.kilobytesToBytes(150);

    public ConfigurationController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.sharedPrefs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            public final SharedPreferences invoke() {
                return this.$context.getSharedPreferences("session_replay_preferences", 0);
            }
        }));
    }

    private final SharedPreferences getSharedPrefs() {
        Lazy lazy = this.sharedPrefs$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (SharedPreferences)object;
    }

    @Override
    @Nullable
    public String getAppId() {
        return this.getSharedPrefs().getString(APP_ID_KEY, null);
    }

    @Override
    @Nullable
    public String getServerUrl() {
        return this.getSharedPrefs().getString(SERVER_URL_KEY, null);
    }

    @Override
    public int getServerId() {
        return this.getSharedPrefs().getInt(SERVER_ID_KEY, 1);
    }

    @Override
    @NotNull
    public TransmissionMode getTransmissionMode() {
        Object object;
        block3: {
            block2: {
                object = this.getSharedPrefs().getString(TRANSMISSION_MODE_KEY, null);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                TransmissionMode transmissionMode = TransmissionMode.valueOf(it);
                object = transmissionMode;
                if (transmissionMode != null) break block3;
            }
            object = TransmissionMode.ALWAYS;
        }
        return object;
    }

    @Override
    public int getMaxBeaconSizeInBytes() {
        return this.getSharedPrefs().getInt(MAX_BEACON_SIZE_IN_BYTES, DEFAULT_MAX_BEACON_SIZE);
    }

    @Override
    public int getDataProtocolVersion() {
        return this.getSharedPrefs().getInt(DATA_PROTOCOL_VERSION, 1);
    }

    @Override
    public boolean isCertificateValidationEnabled() {
        return this.getSharedPrefs().getBoolean(CERTIFICATE_VALIDATION_KEY, true);
    }

    @Override
    public int getSelfMonitoringFlags() {
        return this.getSharedPrefs().getInt(SELFMONITORING_KEY, 0);
    }

    @Override
    public boolean isPixelCopyEnabled() {
        return this.getSharedPrefs().getBoolean(PIXEL_COPY_ENABLED, false);
    }

    @Override
    public boolean isColorMaskingEnabled() {
        return this.getSharedPrefs().getBoolean(COLOR_MASKING_ENABLED, false);
    }

    @Override
    public long getShortRetentionTime--CYLg48() {
        return MillisKt.asMillis((long)600000L);
    }

    @Override
    public long getLongRetentionTime--CYLg48() {
        return MillisKt.asMillis((long)this.getSharedPrefs().getLong(LONG_RETENTION_TIME_KEY, Long.MAX_VALUE));
    }

    public final void setAppId(@NotNull String appId) {
        SharedPreferences.Editor editor;
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setAppId_u24lambda_u241 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setAppId_u24lambda_u241.putString(APP_ID_KEY, appId);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setServerUrl(@NotNull String serverUrl) {
        SharedPreferences.Editor editor;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setServerUrl_u24lambda_u242 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setServerUrl_u24lambda_u242.putString(SERVER_URL_KEY, serverUrl);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setServerId(int serverId) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setServerId_u24lambda_u243 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setServerId_u24lambda_u243.putInt(SERVER_ID_KEY, serverId);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setTransmissionMode(@NotNull TransmissionMode transmissionMode) {
        SharedPreferences.Editor editor;
        Intrinsics.checkNotNullParameter((Object)((Object)transmissionMode), (String)"transmissionMode");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setTransmissionMode_u24lambda_u244 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setTransmissionMode_u24lambda_u244.putString(TRANSMISSION_MODE_KEY, transmissionMode.name());
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setMaxBeaconSizeInBytes(int maxBeaconSizeInB) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setMaxBeaconSizeInBytes_u24lambda_u245 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setMaxBeaconSizeInBytes_u24lambda_u245.putInt(MAX_BEACON_SIZE_IN_BYTES, maxBeaconSizeInB);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setDataProtocolVersion(int dataProtocolVersion) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setDataProtocolVersion_u24lambda_u246 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setDataProtocolVersion_u24lambda_u246.putInt(DATA_PROTOCOL_VERSION, dataProtocolVersion);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setCertificateValidation(boolean validate) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setCertificateValidation_u24lambda_u247 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setCertificateValidation_u24lambda_u247.putBoolean(CERTIFICATE_VALIDATION_KEY, validate);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setSelfMonitoring(int selfMonitoring) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setSelfMonitoring_u24lambda_u248 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setSelfMonitoring_u24lambda_u248.putInt(SELFMONITORING_KEY, selfMonitoring);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setPixelCopyEnabled(boolean pixelCopyEnabled) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setPixelCopyEnabled_u24lambda_u249 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setPixelCopyEnabled_u24lambda_u249.putBoolean(PIXEL_COPY_ENABLED, pixelCopyEnabled);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setColorMaskingEnabled(boolean colorMaskingEnabled) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setColorMaskingEnabled_u24lambda_u2410 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setColorMaskingEnabled_u24lambda_u2410.putBoolean(COLOR_MASKING_ENABLED, colorMaskingEnabled);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void setLongRetentionTime-qBMM6oc(long retentionTimeInMillis) {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$setLongRetentionTime_qBMM6oc_u24lambda_u2411 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$setLongRetentionTime_qBMM6oc_u24lambda_u2411.putLong(LONG_RETENTION_TIME_KEY, retentionTimeInMillis);
        $this$edit_u24lambda_u240$iv.apply();
    }

    public final void clearConfigs() {
        SharedPreferences.Editor editor;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$edit_u24lambda_u240$iv = editor = $this$edit_u24default$iv.edit();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$edit_u24lambda_u240$iv);
        SharedPreferences.Editor $this$clearConfigs_u24lambda_u2412 = $this$edit_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$clearConfigs_u24lambda_u2412.clear();
        $this$edit_u24lambda_u240$iv.apply();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/core/configuration/ConfigurationController$Companion;", "", "()V", "APP_ID_KEY", "", "CERTIFICATE_VALIDATION_KEY", "COLOR_MASKING_ENABLED", "DATA_PROTOCOL_VERSION", "DEFAULT_DATA_PROTOCOL_VERSION", "", "DEFAULT_MAX_BEACON_SIZE", "getDEFAULT_MAX_BEACON_SIZE", "()I", "LONG_RETENTION_TIME_KEY", "MAX_BEACON_SIZE_IN_BYTES", "PIXEL_COPY_ENABLED", "SELFMONITORING_KEY", "SERVER_ID_KEY", "SERVER_URL_KEY", "SESSION_REPLAY_PREFS", "SHORT_RETENTION_TIME_IN_MILLIS", "", "TRANSMISSION_MODE_KEY", "agent_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_MAX_BEACON_SIZE() {
            return DEFAULT_MAX_BEACON_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

