/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqSegment;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.WebRequestUtils;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.mixed.ManualWebRequestEventGenerator;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.util.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.json.JSONObject;

public class WebRequestTiming {
    private static final String LOGTAG = Global.LOG_PREFIX + "WebRequestTiming";
    private final WebReqTag webReqTag;
    private final boolean forwardToGrail;
    private boolean mFinalized = false;
    private long mEventStartTime = -1L;
    private long mEventEndTime = -1L;
    private HttpURLConnection userConnection = null;

    protected WebRequestTiming(String tag) {
        this(tag, true);
    }

    protected WebRequestTiming(String tag, boolean forwardToGrail) {
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("Creating new web request timing for tag " + tag));
        }
        this.webReqTag = WebReqTag.parseTag(tag, Session.currentSession());
        this.forwardToGrail = forwardToGrail;
    }

    @Deprecated
    protected WebRequestTiming(HttpURLConnection connection) {
        this(WebRequestTiming.getTag(connection));
        this.userConnection = connection;
    }

    private static String getTag(HttpURLConnection conn) {
        if (conn != null) {
            String tag = conn.getRequestProperty(Dynatrace.getRequestTagHeader());
            if (tag == null) {
                Dynatrace.tagRequest(conn);
            }
            return conn.getRequestProperty(Dynatrace.getRequestTagHeader());
        }
        return null;
    }

    public void startWebRequestTiming() {
        if (this.webReqTag == null || this.isFinalized()) {
            return;
        }
        this.mEventStartTime = this.webReqTag.getSession().getRunningTime();
    }

    public void stopWebRequestTiming(String requestUrl, int respCode, String respPhrase) throws MalformedURLException {
        if (requestUrl == null) {
            if (Global.DEBUG) {
                Utility.zlogE((String)LOGTAG, (String)"Invalid usage of stopWebRequestTiming(). The argument \"requestUrl\" must not be null");
            }
            return;
        }
        this.stopWebRequestTiming(URI.create(requestUrl), respCode, respPhrase);
    }

    public void stopWebRequestTiming(URL requestUrl, int respCode, String respPhrase) {
        block4: {
            if (requestUrl == null) {
                if (Global.DEBUG) {
                    Utility.zlogE((String)LOGTAG, (String)"Invalid usage of stopWebRequestTiming(). The argument \"requestUrl\" must not be null");
                }
                return;
            }
            try {
                this.stopWebRequestTiming(requestUrl.toURI(), respCode, respPhrase);
            }
            catch (URISyntaxException e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogE((String)LOGTAG, (String)"Invalid usage of stopWebRequestTiming(). The argument \"requestUrl\" is not formatted strictly according to to RFC2396", (Throwable)e);
            }
        }
    }

    public void stopWebRequestTiming(URI requestUri, int respCode, String respPhrase) {
        this.stopWebRequest(requestUri, respCode, respPhrase, -1L, -1L);
    }

    public void stopWebRequestTiming(URI requestUri, int respCode, String respPhrase, long requestSize, long responseSize) {
        this.stopWebRequest(requestUri, respCode, respPhrase, requestSize, responseSize);
    }

    private void stopWebRequest(URI requestUri, int respCode, String respPhrase, long requestSize, long responseSize) {
        if (requestUri == null) {
            if (Global.DEBUG) {
                Utility.zlogE((String)LOGTAG, (String)"Invalid usage of stopWebRequestTiming(). The argument \"requestUri\" must not be null");
            }
            return;
        }
        if (!this.isSchemeExists(requestUri)) {
            if (Global.DEBUG) {
                Utility.zlogE((String)LOGTAG, (String)"Invalid usage of stopWebRequestTiming(). The URI scheme is empty");
            }
            return;
        }
        if (this.mEventStartTime == -1L || this.webReqTag == null) {
            return;
        }
        Session session = this.webReqTag.getSession();
        if (this.isFinalized()) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            this.mFinalized = true;
            return;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("Creating web timing event for " + this.webReqTag));
        }
        this.updateEndTime(session.getRunningTime());
        WebRequestUtils.FormattedUrl formattedUrl = WebRequestUtils.removeUrlCredentials(requestUri.toString());
        String truncatedUrl = Utility.truncateWebRequest((String)formattedUrl.legacyAgentUrl);
        WebReqSegment segment = new WebReqSegment(this.webReqTag.getParentTagId(), this.webReqTag.getSeqNumber(), this.mEventStartTime, this.mEventEndTime, respCode, respPhrase, truncatedUrl, requestSize, responseSize, session, this.webReqTag.getServerId(), null, !session.isGrailEventsShouldBeCaptured());
        Core.saveSegment(segment);
        if (!this.forwardToGrail) {
            return;
        }
        Core.GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
            if (!session.getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
                Utility.devLog((String)"dtxEventGeneration", (String)("stopWebRequest eventType shouldn't be collected, because of data collection level: " + (Object)((Object)EventType.WEB_REQUEST)));
                return;
            }
            ManualWebRequestEventGenerator generator = new ManualWebRequestEventGenerator();
            generator.setUrl(formattedUrl.oneAgentUrl);
            generator.setNetworkProtocolName(requestUri.getScheme());
            generator.setStatusCode(respCode);
            generator.setReasonPhrase(respPhrase);
            JSONObject webRequestEvent = generator.generateRumRequestEvent();
            if (webRequestEvent == null) {
                Utility.devLog((String)"dtxEventGeneration", (String)("manual web request event is invalid " + requestUri));
            } else {
                Utility.devLog((String)"dtxEventGeneration", (String)("manual web request event is generated: " + webRequestEvent));
                long startTime = session.getSessionStartTime() + this.mEventStartTime;
                long duration = this.mEventEndTime - this.mEventStartTime;
                eventDispatcher.dispatchEvent(webRequestEvent, startTime, duration, SessionInformationGenerator.generate(session), true, null);
            }
        });
    }

    boolean isSchemeExists(URI uri) {
        return uri.getScheme() != null;
    }

    private void updateEndTime(long endTime) {
        if (!this.mFinalized) {
            this.mEventEndTime = endTime;
            this.mFinalized = true;
        }
    }

    public boolean isFinalized() {
        return this.mFinalized;
    }

    @Deprecated
    public void stopWebRequestTiming() {
        if (this.userConnection == null) {
            if (Global.DEBUG) {
                Utility.zlogE((String)LOGTAG, (String)"Invalid usage of stopWebRequestTiming().");
            }
            return;
        }
        try {
            this.stopWebRequestTiming(this.userConnection.getURL(), this.userConnection.getResponseCode(), this.userConnection.getResponseMessage());
        }
        catch (IOException e) {
            if (Global.DEBUG) {
                Utility.zlogE((String)LOGTAG, (String)"Unable to retrieve status information for web timing request.", (Throwable)e);
            }
            this.stopWebRequestTiming(this.userConnection.getURL(), 0, e.getMessage());
        }
    }
}

